/*
 * Decompiled with CFR 0.152.
 */
package generativedesign;

import generativedesign.Node;
import processing.core.PApplet;
import processing.core.PVector;

public class Attractor
extends Node {
    private static final long serialVersionUID = 1L;
    public static final int BASIC = 0;
    public static final int SMOOTH = 1;
    public static final int TWIRL = 2;
    public int mode = 1;
    public float strength = 1.0f;
    Node[] nodes = new Node[0];

    public Attractor() {
    }

    public Attractor(float f, float f2) {
        super(f, f2);
    }

    public Attractor(float f, float f2, float f3) {
        super(f, f2, f3);
    }

    public Attractor(PVector pVector) {
        super(pVector);
    }

    public void attachNode(Node node) {
        this.nodes = (Node[])PApplet.append((Object)this.nodes, (Object)((Object)node));
    }

    public void attract() {
        for (int i = 0; i < this.nodes.length; ++i) {
            this.attract(this.nodes[i]);
        }
    }

    public void attract(Node node) {
        float f = this.dist(node);
        float f2 = 0.0f;
        switch (this.mode) {
            case 0: {
                if (!(f > 0.0f) || !(f < this.radius)) break;
                float f3 = f / this.radius;
                f2 = 1.0f / PApplet.pow((float)f3, (float)(0.5f * this.ramp)) - 1.0f;
                f2 = this.strength * f2 / this.radius;
                break;
            }
            case 1: {
                if (!(f > 0.0f) || !(f < this.radius)) break;
                float f3 = PApplet.pow((float)(f / this.radius), (float)(1.0f / this.ramp));
                f2 = f3 * 9.0f * this.strength * (1.0f / (f3 + 1.0f) + (f3 - 3.0f) / 4.0f) / f;
                break;
            }
            case 2: {
                if (!(f > 0.0f) || !(f < this.radius)) break;
                float f3 = PApplet.pow((float)(f / this.radius), (float)(1.0f / this.ramp));
                f2 = f3 * 9.0f * this.strength * (1.0f / (f3 + 1.0f) + (f3 - 3.0f) / 4.0f) / f;
            }
        }
        PVector pVector = PVector.sub((PVector)this, (PVector)node);
        pVector.mult(f2);
        if (this.mode != 2) {
            node.velocity.x += pVector.x;
            node.velocity.y += pVector.y;
            node.velocity.z += pVector.z;
        } else {
            node.velocity.x += pVector.y;
            node.velocity.y -= pVector.x;
            node.velocity.z += pVector.z;
        }
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int n) {
        this.mode = n;
    }

    public float getStrength() {
        return this.strength;
    }

    public void setStrength(float f) {
        this.strength = f;
    }

    public Node[] getNodes() {
        return this.nodes;
    }

    public void setNodes(Node[] nodeArray) {
        this.nodes = nodeArray;
    }
}

