/*
 * Decompiled with CFR 0.152.
 */
package generativedesign;

import generativedesign.GenerativeDesign;
import processing.core.PApplet;

class ColorObject {
    float x = 0.0f;
    float y = 0.0f;
    float z = 0.0f;
    float a = 0.0f;
    float grayscale = 0.0f;
    int c;

    ColorObject(PApplet pApplet, int n) {
        if (pApplet.g.colorMode == 3) {
            this.x = pApplet.hue(n);
            this.y = pApplet.saturation(n);
            this.z = pApplet.brightness(n);
        } else {
            this.x = pApplet.red(n);
            this.y = pApplet.green(n);
            this.z = pApplet.blue(n);
        }
        this.a = pApplet.alpha(n);
        this.c = n;
    }

    ColorObject(PApplet pApplet, int n, float f, float f2, float f3) {
        if (pApplet.g.colorMode == 3) {
            float[] fArray = new float[3];
            fArray = GenerativeDesign.HSBtoRGB(pApplet.hue(n), pApplet.saturation(n), pApplet.brightness(n));
            this.grayscale = fArray[0] * f + fArray[1] * f2 + fArray[2] * f3;
        } else {
            this.grayscale = pApplet.red(n) * f + pApplet.green(n) * f2 + pApplet.blue(n) * f3;
        }
        this.a = pApplet.alpha(n);
        this.c = n;
    }
}

