/*
 * Decompiled with CFR 0.152.
 */
package generativedesign;

import generativedesign.AsyncHTMLLoader;
import generativedesign.AsyncImageLoader;
import generativedesign.AsyncXMLLoader;
import generativedesign.AsyncXMLLoader2;
import generativedesign.ColorObject;
import generativedesign.aComperator;
import generativedesign.grayscaleComperator;
import generativedesign.xComperator;
import generativedesign.yComperator;
import generativedesign.zComperator;
import java.awt.Color;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import processing.core.PApplet;
import processing.core.PImage;
import processing.core.PVector;
import processing.data.XML;
import processing.xml.XMLElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerativeDesign {
    public static String VERSION = "1.0.5";
    public static String RED = "red";
    public static String GREEN = "green";
    public static String BLUE = "blue";
    public static String HUE = "hue";
    public static String SATURATION = "saturation";
    public static String BRIGHTNESS = "brightness";
    public static String GRAYSCALE = "grayscale";
    public static String ALPHA = "alpha";
    public static int HTML_PLAIN = 0;
    public static int HTML_CONTENT = 1;

    public static String version() {
        return VERSION;
    }

    public static String timestamp() {
        Calendar calendar = Calendar.getInstance();
        return String.format("%1$ty%1$tm%1$td_%1$tH%1$tM%1$tS", calendar);
    }

    public static float[] RGBtoHSB(float f, float f2, float f3) {
        float[] fArray = new float[3];
        Color.RGBtoHSB((int)f, (int)f2, (int)f3, fArray);
        fArray[0] = fArray[0] * 360.0f;
        fArray[1] = fArray[1] * 100.0f;
        fArray[2] = fArray[2] * 100.0f;
        return fArray;
    }

    public static float[] HSBtoRGB(float f, float f2, float f3) {
        float[] fArray = new float[3];
        Color color = new Color(Color.HSBtoRGB(f / 360.0f, f2 / 100.0f, f3 / 100.0f));
        fArray[0] = color.getRed();
        fArray[1] = color.getGreen();
        fArray[2] = color.getBlue();
        return fArray;
    }

    public static int[] sortColors(PApplet pApplet, int[] nArray, String string) {
        string = string.toLowerCase();
        ColorObject[] colorObjectArray = new ColorObject[nArray.length];
        for (int i = 0; i < colorObjectArray.length; ++i) {
            colorObjectArray[i] = string.equals(GRAYSCALE) ? new ColorObject(pApplet, nArray[i], 0.3f, 0.59f, 0.11f) : new ColorObject(pApplet, nArray[i]);
        }
        if (string.equals(HUE) || string.equals(RED)) {
            xComperator xComperator2 = new xComperator();
            Arrays.sort(colorObjectArray, xComperator2);
        } else if (string.equals(SATURATION) || string.equals(GREEN)) {
            yComperator yComperator2 = new yComperator();
            Arrays.sort(colorObjectArray, yComperator2);
        } else if (string.equals(BRIGHTNESS) || string.equals(BLUE)) {
            zComperator zComperator2 = new zComperator();
            Arrays.sort(colorObjectArray, zComperator2);
        } else if (string.equals(ALPHA)) {
            aComperator aComperator2 = new aComperator();
            Arrays.sort(colorObjectArray, aComperator2);
        } else if (string.equals(GRAYSCALE)) {
            grayscaleComperator grayscaleComperator2 = new grayscaleComperator();
            Arrays.sort(colorObjectArray, grayscaleComperator2);
        }
        for (int i = 0; i < colorObjectArray.length; ++i) {
            nArray[i] = colorObjectArray[i].c;
        }
        return nArray;
    }

    public static void saveASE(PApplet pApplet, int[] nArray, String string) {
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i] >> 16 & 0xFF;
            int n2 = nArray[i] >> 8 & 0xFF;
            int n3 = nArray[i] & 0xFF;
            stringArray[i] = "R=" + PApplet.nf((int)n, (int)3) + " G=" + PApplet.nf((int)n2, (int)3) + " B=" + PApplet.nf((int)n3, (int)3);
        }
        GenerativeDesign.saveASE(pApplet, nArray, stringArray, string);
    }

    public static void saveASE(PApplet pApplet, int[] nArray, String[] stringArray, String string) {
        int n;
        String string2 = new Character('\u0000').toString();
        String string3 = new Character('\u0001').toString();
        int n2 = nArray.length;
        String string4 = "ASEF" + string2 + string3 + string2 + string2;
        for (n = 24; n >= 0; n -= 8) {
            string4 = string4 + new Character((char)(n2 >> n & 0xFF)).toString();
        }
        string4 = string4 + string2;
        for (n = 0; n < n2; ++n) {
            string4 = string4 + string3 + string2 + string2 + string2;
            string4 = string4 + new Character((char)((stringArray[n].length() + 1) * 2 + 20)).toString() + string2;
            string4 = string4 + new Character((char)(stringArray[n].length() + 1)).toString() + string2;
            for (int i = 0; i < stringArray[n].length(); ++i) {
                string4 = string4 + stringArray[n].substring(i, i + 1) + string2;
            }
            float f = nArray[n] >> 16 & 0xFF;
            float f2 = nArray[n] >> 8 & 0xFF;
            float f3 = nArray[n] & 0xFF;
            String string5 = new String(GenerativeDesign.floatTobytes(f / 255.0f));
            String string6 = new String(GenerativeDesign.floatTobytes(f2 / 255.0f));
            String string7 = new String(GenerativeDesign.floatTobytes(f3 / 255.0f));
            string4 = string4 + string2 + "RGB ";
            string4 = string4 + string5.substring(0, 1) + string5.substring(1, 2) + string5.substring(2, 3) + string2;
            string4 = string4 + string6.substring(0, 1) + string6.substring(1, 2) + string6.substring(2, 3) + string2;
            string4 = string4 + string7.substring(0, 1) + string7.substring(1, 2) + string7.substring(2, 3) + string2;
            if (n + 1 == n2) continue;
            string4 = string4 + string2 + string2 + string2;
        }
        string4 = string4 + string2 + string2;
        byte[] byArray = string4.getBytes();
        pApplet.saveBytes(string, byArray);
    }

    private static byte[] floatTobytes(float f) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putFloat(f);
        return byteBuffer.array();
    }

    public static PImage loadImageAsync(PApplet pApplet, String string) {
        PImage pImage = new PImage();
        new AsyncImageLoader(pApplet, string, pImage);
        return pImage;
    }

    public static XML loadXMLAsync2(PApplet pApplet, String string) {
        XML xML = new XML("test");
        new AsyncXMLLoader2(pApplet, string, xML);
        return xML;
    }

    public static XMLElement loadXMLAsync(PApplet pApplet, String string) {
        XMLElement xMLElement = new XMLElement();
        new AsyncXMLLoader(pApplet, string, xMLElement);
        return xMLElement;
    }

    public static ArrayList<String> loadHTMLAsync(PApplet pApplet, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        new AsyncHTMLLoader(pApplet, string, arrayList);
        return arrayList;
    }

    public static ArrayList<String> loadHTMLAsync(PApplet pApplet, String string, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        new AsyncHTMLLoader(pApplet, string, arrayList, n);
        return arrayList;
    }

    public static float angleDifference(float f, float f2) {
        float f3 = (f2 % ((float)Math.PI * 2) + (float)Math.PI * 2) % ((float)Math.PI * 2);
        float f4 = (f % ((float)Math.PI * 2) + (float)Math.PI * 2) % ((float)Math.PI * 2);
        if (f3 > f4) {
            float f5 = f3 - f4;
            float f6 = f4 + (float)Math.PI * 2 - f3;
            if (f5 <= f6) {
                return -f5;
            }
            return f6;
        }
        float f7 = f4 - f3;
        float f8 = f3 + (float)Math.PI * 2 - f4;
        if (f7 <= f8) {
            return f7;
        }
        return -f8;
    }

    public static float[] cartesianToPolar(float f, float f2) {
        float[] fArray = new float[]{PApplet.mag((float)f, (float)f2), PApplet.atan2((float)f2, (float)f)};
        return fArray;
    }

    public static float[] cartesianToPolar(float f, float f2, float f3) {
        float[] fArray = new float[3];
        fArray[0] = PApplet.mag((float)f, (float)f2, (float)f3);
        if (fArray[0] > 0.0f) {
            fArray[1] = -PApplet.atan2((float)f3, (float)f);
            fArray[2] = PApplet.asin((float)(f2 / fArray[0]));
        } else {
            fArray[1] = 0.0f;
            fArray[2] = 0.0f;
        }
        return fArray;
    }

    public static PVector cartesianToPolar(PVector pVector) {
        PVector pVector2 = new PVector();
        pVector2.x = pVector.mag();
        if (pVector2.x > 0.0f) {
            pVector2.y = -PApplet.atan2((float)pVector.z, (float)pVector.x);
            pVector2.z = PApplet.asin((float)(pVector.y / pVector2.x));
        } else {
            pVector2.y = 0.0f;
            pVector2.z = 0.0f;
        }
        return pVector2;
    }

    public static float[] polarToCartesian(float f, float f2) {
        float[] fArray = new float[]{PApplet.cos((float)f2) * f, PApplet.sin((float)f2) * f};
        return fArray;
    }

    public static float[] polarToCartesian(float f, float f2, float f3) {
        float[] fArray = new float[]{PApplet.cos((float)f3) * PApplet.cos((float)f2) * f, PApplet.sin((float)f3) * f, -PApplet.cos((float)f3) * PApplet.sin((float)f2) * f};
        return fArray;
    }

    public static PVector polarToCartesian(PVector pVector) {
        PVector pVector2 = new PVector();
        pVector2.x = PApplet.cos((float)pVector.z) * PApplet.cos((float)pVector.y) * pVector.x;
        pVector2.y = PApplet.sin((float)pVector.z) * pVector.x;
        pVector2.z = -PApplet.cos((float)pVector.z) * PApplet.sin((float)pVector.y) * pVector.x;
        return pVector2;
    }

    public static void unsort(ArrayList<Object> arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            Object object = arrayList.get(i);
            int n = (int)(Math.random() * (double)arrayList.size());
            Object object2 = arrayList.get(n);
            arrayList.set(i, object2);
            arrayList.set(n, object);
        }
    }
}

