/*
 * Decompiled with CFR 0.152.
 */
package generativedesign;

import processing.core.PApplet;
import processing.core.PVector;

public class Mesh
extends PApplet {
    private PApplet parent;
    private static final long serialVersionUID = 1L;
    public static final int PLANE = 0;
    public static final int TUBE = 1;
    public static final int SPHERE = 2;
    public static final int TORUS = 3;
    public static final int PARABOLOID = 4;
    public static final int STEINBACHSCREW = 5;
    public static final int SINE = 6;
    public static final int FIGURE8TORUS = 7;
    public static final int ELLIPTICTORUS = 8;
    public static final int CORKSCREW = 9;
    public static final int BOHEMIANDOME = 10;
    public static final int BOW = 11;
    public static final int MAEDERSOWL = 12;
    public static final int ASTROIDALELLIPSOID = 13;
    public static final int TRIAXIALTRITORUS = 14;
    public static final int LIMPETTORUS = 15;
    public static final int HORN = 16;
    public static final int SHELL = 17;
    public static final int KIDNEY = 18;
    public static final int LEMNISCAPE = 19;
    public static final int TRIANGULOID = 20;
    public static final int SUPERFORMULA = 21;
    public int form = 4;
    public float uMin = (float)(-Math.PI);
    public float uMax = (float)Math.PI;
    public int uCount = 50;
    public float vMin = (float)(-Math.PI);
    public float vMax = (float)Math.PI;
    public int vCount = 50;
    public float[] params = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    public int drawMode = 10;
    public float minHue = 0.0f;
    public float maxHue = 0.0f;
    public float minSaturation = 0.0f;
    public float maxSaturation = 0.0f;
    public float minBrightness = 100.0f;
    public float maxBrightness = 100.0f;
    public float meshAlpha = 100.0f;
    public float meshDistortion = 0.0f;
    PVector[][] points;

    public Mesh(PApplet pApplet) {
        this.parent = pApplet;
        this.form = 0;
        this.update();
    }

    public Mesh(PApplet pApplet, int n) {
        this.parent = pApplet;
        if (n >= 0) {
            this.form = n;
        }
        this.update();
    }

    public Mesh(PApplet pApplet, int n, int n2, int n3) {
        this.parent = pApplet;
        if (n >= 0) {
            this.form = n;
        }
        this.uCount = Mesh.max((int)n2, (int)1);
        this.vCount = Mesh.max((int)n3, (int)1);
        this.update();
    }

    public Mesh(PApplet pApplet, int n, float f, float f2, float f3, float f4) {
        this.parent = pApplet;
        if (n >= 0) {
            this.form = n;
        }
        this.uMin = f;
        this.uMax = f2;
        this.vMin = f3;
        this.vMax = f4;
        this.update();
    }

    public Mesh(PApplet pApplet, int n, int n2, int n3, float f, float f2, float f3, float f4) {
        this.parent = pApplet;
        if (n >= 0) {
            this.form = n;
        }
        this.uCount = Mesh.max((int)n2, (int)1);
        this.vCount = Mesh.max((int)n3, (int)1);
        this.uMin = f;
        this.uMax = f2;
        this.vMin = f3;
        this.vMax = f4;
        this.update();
    }

    public void update() {
        this.points = new PVector[this.vCount + 1][this.uCount + 1];
        for (int i = 0; i <= this.vCount; ++i) {
            block25: for (int j = 0; j <= this.uCount; ++j) {
                float f = Mesh.map((float)j, (float)0.0f, (float)this.uCount, (float)this.uMin, (float)this.uMax);
                float f2 = Mesh.map((float)i, (float)0.0f, (float)this.vCount, (float)this.vMin, (float)this.vMax);
                switch (this.form) {
                    case 0: {
                        this.points[i][j] = this.calculatePoints(f, f2);
                        continue block25;
                    }
                    case 1: {
                        this.points[i][j] = this.calculateTube(f, f2);
                        continue block25;
                    }
                    case 2: {
                        this.points[i][j] = this.calculateSphere(f, f2);
                        continue block25;
                    }
                    case 3: {
                        this.points[i][j] = this.calculateTorus(f, f2);
                        continue block25;
                    }
                    case 4: {
                        this.points[i][j] = this.calculateParaboloid(f, f2);
                        continue block25;
                    }
                    case 5: {
                        this.points[i][j] = this.calculateSteinbachScrew(f, f2);
                        continue block25;
                    }
                    case 6: {
                        this.points[i][j] = this.calculateSine(f, f2);
                        continue block25;
                    }
                    case 7: {
                        this.points[i][j] = this.calculateFigure8Torus(f, f2);
                        continue block25;
                    }
                    case 8: {
                        this.points[i][j] = this.calculateEllipticTorus(f, f2);
                        continue block25;
                    }
                    case 9: {
                        this.points[i][j] = this.calculateCorkscrew(f, f2);
                        continue block25;
                    }
                    case 10: {
                        this.points[i][j] = this.calculateBohemianDome(f, f2);
                        continue block25;
                    }
                    case 11: {
                        this.points[i][j] = this.calculateBow(f, f2);
                        continue block25;
                    }
                    case 12: {
                        this.points[i][j] = this.calculateMaedersOwl(f, f2);
                        continue block25;
                    }
                    case 13: {
                        this.points[i][j] = this.calculateAstroidalEllipsoid(f, f2);
                        continue block25;
                    }
                    case 14: {
                        this.points[i][j] = this.calculateTriaxialTritorus(f, f2);
                        continue block25;
                    }
                    case 15: {
                        this.points[i][j] = this.calculateLimpetTorus(f, f2);
                        continue block25;
                    }
                    case 16: {
                        this.points[i][j] = this.calculateHorn(f, f2);
                        continue block25;
                    }
                    case 17: {
                        this.points[i][j] = this.calculateShell(f, f2);
                        continue block25;
                    }
                    case 18: {
                        this.points[i][j] = this.calculateKidney(f, f2);
                        continue block25;
                    }
                    case 19: {
                        this.points[i][j] = this.calculateLemniscape(f, f2);
                        continue block25;
                    }
                    case 20: {
                        this.points[i][j] = this.calculateTrianguloid(f, f2);
                        continue block25;
                    }
                    case 21: {
                        this.points[i][j] = this.calculateSuperformula(f, f2);
                        continue block25;
                    }
                    default: {
                        this.points[i][j] = this.calculatePoints(f, f2);
                    }
                }
            }
        }
    }

    public PVector calculatePoints(float f, float f2) {
        float f3 = f;
        float f4 = f2;
        float f5 = 0.0f;
        return new PVector(f3, f4, f5);
    }

    public PVector calculateTube(float f, float f2) {
        float f3 = Mesh.sin((float)f);
        float f4 = this.params[0] * f2;
        float f5 = Mesh.cos((float)f);
        return new PVector(f3, f4, f5);
    }

    public PVector calculateSphere(float f, float f2) {
        f2 /= 2.0f;
        float f3 = 2.0f * (Mesh.sin((float)(f2 += 1.5707964f)) * Mesh.sin((float)f));
        float f4 = 2.0f * (this.params[0] * Mesh.cos((float)f2));
        float f5 = 2.0f * (Mesh.sin((float)f2) * Mesh.cos((float)f));
        return new PVector(f3, f4, f5);
    }

    public PVector calculateTorus(float f, float f2) {
        float f3 = 1.0f * ((this.params[1] + 1.0f + this.params[0] * Mesh.cos((float)f2)) * Mesh.sin((float)f));
        float f4 = 1.0f * (this.params[0] * Mesh.sin((float)f2));
        float f5 = 1.0f * ((this.params[1] + 1.0f + this.params[0] * Mesh.cos((float)f2)) * Mesh.cos((float)f));
        return new PVector(f3, f4, f5);
    }

    public PVector calculateParaboloid(float f, float f2) {
        float f3 = this.params[0];
        if (f3 == 0.0f) {
            f3 = 1.0E-4f;
        }
        float f4 = this.power(f2 / f3, 0.5f) * Mesh.sin((float)f);
        float f5 = f2;
        float f6 = this.power(f2 / f3, 0.5f) * Mesh.cos((float)f);
        return new PVector(f4, f5, f6);
    }

    public PVector calculateSteinbachScrew(float f, float f2) {
        float f3 = f * Mesh.cos((float)f2);
        float f4 = f * Mesh.sin((float)(this.params[0] * f2));
        float f5 = f2 * Mesh.cos((float)f);
        return new PVector(f3, f4, f5);
    }

    public PVector calculateSine(float f, float f2) {
        float f3 = 2.0f * Mesh.sin((float)f);
        float f4 = 2.0f * Mesh.sin((float)(this.params[0] * f2));
        float f5 = 2.0f * Mesh.sin((float)(f + f2));
        return new PVector(f3, f4, f5);
    }

    public PVector calculateFigure8Torus(float f, float f2) {
        float f3 = 1.5f * Mesh.cos((float)f) * (this.params[0] + Mesh.sin((float)f2) * Mesh.cos((float)f) - Mesh.sin((float)(2.0f * f2)) * Mesh.sin((float)f) / 2.0f);
        float f4 = 1.5f * Mesh.sin((float)f) * (this.params[0] + Mesh.sin((float)f2) * Mesh.cos((float)f) - Mesh.sin((float)(2.0f * f2)) * Mesh.sin((float)f) / 2.0f);
        float f5 = 1.5f * Mesh.sin((float)f) * Mesh.sin((float)f2) + Mesh.cos((float)f) * Mesh.sin((float)(2.0f * f2)) / 2.0f;
        return new PVector(f3, f4, f5);
    }

    public PVector calculateEllipticTorus(float f, float f2) {
        float f3 = 1.5f * (this.params[0] + Mesh.cos((float)f2)) * Mesh.cos((float)f);
        float f4 = 1.5f * (this.params[0] + Mesh.cos((float)f2)) * Mesh.sin((float)f);
        float f5 = 1.5f * Mesh.sin((float)f2) + Mesh.cos((float)f2);
        return new PVector(f3, f4, f5);
    }

    public PVector calculateCorkscrew(float f, float f2) {
        float f3 = Mesh.cos((float)f) * Mesh.cos((float)f2);
        float f4 = Mesh.sin((float)f) * Mesh.cos((float)f2);
        float f5 = Mesh.sin((float)f2) + this.params[0] * f;
        return new PVector(f3, f4, f5);
    }

    public PVector calculateBohemianDome(float f, float f2) {
        float f3 = 2.0f * Mesh.cos((float)f);
        float f4 = 2.0f * Mesh.sin((float)f) + this.params[0] * Mesh.cos((float)f2);
        float f5 = 2.0f * Mesh.sin((float)f2);
        return new PVector(f3, f4, f5);
    }

    public PVector calculateBow(float f, float f2) {
        float f3 = (2.0f + this.params[0] * Mesh.sin((float)((float)Math.PI * 2 * (f /= (float)Math.PI * 2)))) * Mesh.sin((float)((float)Math.PI * 4 * (f2 /= (float)Math.PI * 2)));
        float f4 = (2.0f + this.params[0] * Mesh.sin((float)((float)Math.PI * 2 * f))) * Mesh.cos((float)((float)Math.PI * 4 * f2));
        float f5 = this.params[0] * Mesh.cos((float)((float)Math.PI * 2 * f)) + 3.0f * Mesh.cos((float)((float)Math.PI * 2 * f2));
        return new PVector(f3, f4, f5);
    }

    public PVector calculateMaedersOwl(float f, float f2) {
        float f3 = 0.4f * (f2 * Mesh.cos((float)f) - 0.5f * this.params[0] * this.power(f2, 2.0f) * Mesh.cos((float)(2.0f * f)));
        float f4 = 0.4f * (-f2 * Mesh.sin((float)f) - 0.5f * this.params[0] * this.power(f2, 2.0f) * Mesh.sin((float)(2.0f * f)));
        float f5 = 0.4f * (4.0f * this.power(f2, 1.5f) * Mesh.cos((float)(3.0f * f / 2.0f)) / 3.0f);
        return new PVector(f3, f4, f5);
    }

    public PVector calculateAstroidalEllipsoid(float f, float f2) {
        float f3 = 3.0f * this.power(Mesh.cos((float)(f /= 2.0f)) * Mesh.cos((float)f2), 3.0f * this.params[0]);
        float f4 = 3.0f * this.power(Mesh.sin((float)f) * Mesh.cos((float)f2), 3.0f * this.params[0]);
        float f5 = 3.0f * this.power(Mesh.sin((float)f2), 3.0f * this.params[0]);
        return new PVector(f3, f4, f5);
    }

    public PVector calculateTriaxialTritorus(float f, float f2) {
        float f3 = 1.5f * Mesh.sin((float)f) * (1.0f + Mesh.cos((float)f2));
        float f4 = 1.5f * Mesh.sin((float)(f + 2.0943952f * this.params[0])) * (1.0f + Mesh.cos((float)(f2 + 2.0943952f * this.params[0])));
        float f5 = 1.5f * Mesh.sin((float)(f + 4.1887903f * this.params[0])) * (1.0f + Mesh.cos((float)(f2 + 4.1887903f * this.params[0])));
        return new PVector(f3, f4, f5);
    }

    public PVector calculateLimpetTorus(float f, float f2) {
        float f3 = 1.5f * this.params[0] * Mesh.cos((float)f) / (Mesh.sqrt((float)2.0f) + Mesh.sin((float)f2));
        float f4 = 1.5f * this.params[0] * Mesh.sin((float)f) / (Mesh.sqrt((float)2.0f) + Mesh.sin((float)f2));
        float f5 = 1.5f / (Mesh.sqrt((float)2.0f) + Mesh.cos((float)f2));
        return new PVector(f3, f4, f5);
    }

    public PVector calculateHorn(float f, float f2) {
        float f3 = (2.0f * this.params[0] + (f /= (float)Math.PI) * Mesh.cos((float)f2)) * Mesh.sin((float)((float)Math.PI * 2 * f));
        float f4 = (2.0f * this.params[0] + f * Mesh.cos((float)f2)) * Mesh.cos((float)((float)Math.PI * 2 * f)) + 2.0f * f;
        float f5 = f * Mesh.sin((float)f2);
        return new PVector(f3, f4, f5);
    }

    public PVector calculateShell(float f, float f2) {
        float f3 = this.params[1] * (1.0f - f / ((float)Math.PI * 2)) * Mesh.cos((float)(this.params[0] * f)) * (1.0f + Mesh.cos((float)f2)) + this.params[3] * Mesh.cos((float)(this.params[0] * f));
        float f4 = this.params[1] * (1.0f - f / ((float)Math.PI * 2)) * Mesh.sin((float)(this.params[0] * f)) * (1.0f + Mesh.cos((float)f2)) + this.params[3] * Mesh.sin((float)(this.params[0] * f));
        float f5 = this.params[2] * (f / ((float)Math.PI * 2)) + this.params[0] * (1.0f - f / ((float)Math.PI * 2)) * Mesh.sin((float)f2);
        return new PVector(f3, f4, f5);
    }

    public PVector calculateKidney(float f, float f2) {
        float f3 = Mesh.cos((float)(f /= 2.0f)) * (this.params[0] * 3.0f * Mesh.cos((float)f2) - Mesh.cos((float)(3.0f * f2)));
        float f4 = Mesh.sin((float)f) * (this.params[0] * 3.0f * Mesh.cos((float)f2) - Mesh.cos((float)(3.0f * f2)));
        float f5 = 3.0f * Mesh.sin((float)f2) - Mesh.sin((float)(3.0f * f2));
        return new PVector(f3, f4, f5);
    }

    public PVector calculateLemniscape(float f, float f2) {
        float f3 = Mesh.cos((float)f2) * Mesh.sqrt((float)Mesh.abs((float)Mesh.sin((float)(2.0f * this.params[0] * (f /= 2.0f)))));
        float f4 = f3 * Mesh.cos((float)f);
        float f5 = f3 * Mesh.sin((float)f);
        float f6 = 3.0f * (this.power(f4, 2.0f) - this.power(f5, 2.0f) + 2.0f * f4 * f5 * this.power(Mesh.tan((float)f2), 2.0f));
        return new PVector(f4 *= 3.0f, f5 *= 3.0f, f6);
    }

    public PVector calculateTrianguloid(float f, float f2) {
        float f3 = 0.75f * (Mesh.sin((float)(3.0f * f)) * 2.0f / (2.0f + Mesh.cos((float)f2)));
        float f4 = 0.75f * ((Mesh.sin((float)f) + 2.0f * this.params[0] * Mesh.sin((float)(2.0f * f))) * 2.0f / (2.0f + Mesh.cos((float)(f2 + (float)Math.PI * 2))));
        float f5 = 0.75f * ((Mesh.cos((float)f) - 2.0f * this.params[0] * Mesh.cos((float)(2.0f * f))) * (2.0f + Mesh.cos((float)f2)) * ((2.0f + Mesh.cos((float)(f2 + 2.0943952f))) * 0.25f));
        return new PVector(f3, f4, f5);
    }

    public PVector calculateSuperformula(float f, float f2) {
        f2 /= 2.0f;
        float f3 = this.params[0];
        float f4 = this.params[1];
        float f5 = this.params[2];
        float f6 = this.params[3];
        float f7 = this.params[4];
        float f8 = this.params[5];
        float f9 = Mesh.pow((float)(Mesh.pow((float)Mesh.abs((float)(Mesh.cos((float)(f5 * f / 4.0f)) / f3)), (float)f7) + Mesh.pow((float)Mesh.abs((float)(Mesh.sin((float)(f5 * f / 4.0f)) / f4)), (float)f8)), (float)(-1.0f / f6));
        f3 = this.params[6];
        f4 = this.params[7];
        f5 = this.params[8];
        f6 = this.params[9];
        f7 = this.params[10];
        f8 = this.params[11];
        float f10 = Mesh.pow((float)(Mesh.pow((float)Mesh.abs((float)(Mesh.cos((float)(f5 * f2 / 4.0f)) / f3)), (float)f7) + Mesh.pow((float)Mesh.abs((float)(Mesh.sin((float)(f5 * f2 / 4.0f)) / f4)), (float)f8)), (float)(-1.0f / f6));
        float f11 = 2.0f * (f9 * Mesh.sin((float)f) * f10 * Mesh.cos((float)f2));
        float f12 = 2.0f * (f10 * Mesh.sin((float)f2));
        float f13 = 2.0f * (f9 * Mesh.cos((float)f) * f10 * Mesh.cos((float)f2));
        return new PVector(f11, f12, f13);
    }

    public float power(float f, float f2) {
        if (f >= 0.0f || (float)PApplet.parseInt((float)f2) == f2) {
            return Mesh.pow((float)f, (float)f2);
        }
        return -Mesh.pow((float)(-f), (float)f2);
    }

    public float logE(float f) {
        if (f >= 0.0f) {
            return Mesh.log((float)f);
        }
        return -Mesh.log((float)(-f));
    }

    public void draw() {
        float f;
        float f2;
        float f3;
        float f4;
        int n;
        int n2;
        if (this.drawMode == 17 || this.drawMode == 9) {
            n2 = this.uCount - 1;
            n = this.vCount - 1;
        } else {
            n2 = this.uCount;
            n = this.vCount - 1;
        }
        this.parent.pushStyle();
        this.parent.colorMode(3, 360.0f, 100.0f, 100.0f, 100.0f);
        float f5 = this.minHue;
        float f6 = this.maxHue;
        if (Mesh.abs((float)(f6 - f5)) < 20.0f) {
            f6 = f5;
        }
        if (Mesh.abs((float)((f4 = this.maxSaturation) - (f3 = this.minSaturation))) < 10.0f) {
            f4 = f3;
        }
        if (Mesh.abs((float)((f2 = this.maxBrightness) - (f = this.minBrightness))) < 10.0f) {
            f2 = f;
        }
        for (int i = 0; i <= n; ++i) {
            float f7;
            float f8;
            float f9;
            int n3;
            if (this.drawMode == 9) {
                for (n3 = 0; n3 <= n2; ++n3) {
                    this.parent.fill(this.random(f5, f6), this.random(f3, f4), this.random(f, f2), this.meshAlpha);
                    this.parent.beginShape(this.drawMode);
                    f9 = this.random(-this.meshDistortion, this.meshDistortion);
                    f8 = this.random(-this.meshDistortion, this.meshDistortion);
                    f7 = this.random(-this.meshDistortion, this.meshDistortion);
                    this.parent.vertex(this.points[i][n3].x + f9, this.points[i][n3].y + f8, this.points[i][n3].z + f7);
                    this.parent.vertex(this.points[i + 1][n3 + 1].x + f9, this.points[i + 1][n3 + 1].y + f8, this.points[i + 1][n3 + 1].z + f7);
                    this.parent.vertex(this.points[i + 1][n3].x + f9, this.points[i + 1][n3].y + f8, this.points[i + 1][n3].z + f7);
                    this.parent.endShape();
                    this.parent.fill(this.random(f5, f6), this.random(f3, f4), this.random(f, f2), this.meshAlpha);
                    this.parent.beginShape(this.drawMode);
                    f9 = this.random(-this.meshDistortion, this.meshDistortion);
                    f8 = this.random(-this.meshDistortion, this.meshDistortion);
                    f7 = this.random(-this.meshDistortion, this.meshDistortion);
                    this.parent.vertex(this.points[i + 1][n3 + 1].x + f9, this.points[i + 1][n3 + 1].y + f8, this.points[i + 1][n3 + 1].z + f7);
                    this.parent.vertex(this.points[i][n3].x + f9, this.points[i][n3].y + f8, this.points[i][n3].z + f7);
                    this.parent.vertex(this.points[i][n3 + 1].x + f9, this.points[i][n3 + 1].y + f8, this.points[i][n3 + 1].z + f7);
                    this.parent.endShape();
                }
                continue;
            }
            if (this.drawMode == 17) {
                for (n3 = 0; n3 <= n2; ++n3) {
                    this.parent.fill(this.random(f5, f6), this.random(f3, f4), this.random(f, f2), this.meshAlpha);
                    this.parent.beginShape(this.drawMode);
                    f9 = this.random(-this.meshDistortion, this.meshDistortion);
                    f8 = this.random(-this.meshDistortion, this.meshDistortion);
                    f7 = this.random(-this.meshDistortion, this.meshDistortion);
                    this.parent.vertex(this.points[i][n3].x + f9, this.points[i][n3].y + f8, this.points[i][n3].z + f7);
                    this.parent.vertex(this.points[i + 1][n3].x + f9, this.points[i + 1][n3].y + f8, this.points[i + 1][n3].z + f7);
                    this.parent.vertex(this.points[i + 1][n3 + 1].x + f9, this.points[i + 1][n3 + 1].y + f8, this.points[i + 1][n3 + 1].z + f7);
                    this.parent.vertex(this.points[i][n3 + 1].x + f9, this.points[i][n3 + 1].y + f8, this.points[i][n3 + 1].z + f7);
                    this.parent.endShape();
                }
                continue;
            }
            this.parent.fill(this.random(f5, f6), this.random(f3, f4), this.random(f, f2), this.meshAlpha);
            this.parent.beginShape(this.drawMode);
            for (n3 = 0; n3 <= n2; ++n3) {
                f9 = this.random(-this.meshDistortion, this.meshDistortion);
                f8 = this.random(-this.meshDistortion, this.meshDistortion);
                f7 = this.random(-this.meshDistortion, this.meshDistortion);
                this.parent.vertex(this.points[i][n3].x + f9, this.points[i][n3].y + f8, this.points[i][n3].z + f7);
                this.parent.vertex(this.points[i + 1][n3].x + f9, this.points[i + 1][n3].y + f8, this.points[i + 1][n3].z + f7);
            }
            this.parent.endShape();
        }
        this.parent.popStyle();
    }

    public int getForm() {
        return this.form;
    }

    public void setForm(int n) {
        this.form = n;
    }

    public String getFormName() {
        switch (this.form) {
            case 0: {
                return "Custom";
            }
            case 1: {
                return "Tube";
            }
            case 2: {
                return "Sphere";
            }
            case 3: {
                return "Torus";
            }
            case 4: {
                return "Paraboloid";
            }
            case 5: {
                return "Steinbach Screw";
            }
            case 6: {
                return "Sine";
            }
            case 7: {
                return "Figure 8 Torus";
            }
            case 8: {
                return "Elliptic Torus";
            }
            case 9: {
                return "Corkscrew";
            }
            case 10: {
                return "Bohemian Dome";
            }
            case 11: {
                return "Bow";
            }
            case 12: {
                return "Maeders Owl";
            }
            case 13: {
                return "Astoidal Ellipsoid";
            }
            case 14: {
                return "Triaxial Tritorus";
            }
            case 15: {
                return "Limpet Torus";
            }
            case 16: {
                return "Horn";
            }
            case 17: {
                return "Shell";
            }
            case 18: {
                return "Kidney";
            }
            case 19: {
                return "Lemniscape";
            }
            case 20: {
                return "Trianguloid";
            }
            case 21: {
                return "Superformula";
            }
        }
        return "";
    }

    public float getUMin() {
        return this.uMin;
    }

    public void setUMin(float f) {
        this.uMin = f;
    }

    public float getUMax() {
        return this.uMax;
    }

    public void setUMax(float f) {
        this.uMax = f;
    }

    public int getUCount() {
        return this.uCount;
    }

    public void setUCount(int n) {
        this.uCount = n;
    }

    public float getVMin() {
        return this.vMin;
    }

    public void setVMin(float f) {
        this.vMin = f;
    }

    public float getVMax() {
        return this.vMax;
    }

    public void setVMax(float f) {
        this.vMax = f;
    }

    public int getVCount() {
        return this.vCount;
    }

    public void setVCount(int n) {
        this.vCount = n;
    }

    public float[] getParams() {
        return this.params;
    }

    public void setParams(float[] fArray) {
        this.params = fArray;
    }

    public float getParam(int n) {
        return this.params[n];
    }

    public void setParam(int n, float f) {
        this.params[n] = f;
    }

    public int getDrawMode() {
        return this.drawMode;
    }

    public void setDrawMode(int n) {
        this.drawMode = n;
    }

    public float getMeshDistortion() {
        return this.meshDistortion;
    }

    public void setMeshDistortion(float f) {
        this.meshDistortion = f;
    }

    public void setColorRange(float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        this.minHue = f;
        this.maxHue = f2;
        this.minSaturation = f3;
        this.maxSaturation = f4;
        this.minBrightness = f5;
        this.maxBrightness = f6;
        this.meshAlpha = f7;
    }

    public float getMinHue() {
        return this.minHue;
    }

    public void setMinHue(float f) {
        this.minHue = f;
    }

    public float getMaxHue() {
        return this.maxHue;
    }

    public void setMaxHue(float f) {
        this.maxHue = f;
    }

    public float getMinSaturation() {
        return this.minSaturation;
    }

    public void setMinSaturation(float f) {
        this.minSaturation = f;
    }

    public float getMaxSaturation() {
        return this.maxSaturation;
    }

    public void setMaxSaturation(float f) {
        this.maxSaturation = f;
    }

    public float getMinBrightness() {
        return this.minBrightness;
    }

    public void setMinBrightness(float f) {
        this.minBrightness = f;
    }

    public float getMaxBrightness() {
        return this.maxBrightness;
    }

    public void setMaxBrightness(float f) {
        this.maxBrightness = f;
    }

    public float getMeshAlpha() {
        return this.meshAlpha;
    }

    public void setMeshAlpha(float f) {
        this.meshAlpha = f;
    }
}

