/*
 * Decompiled with CFR 0.152.
 */
package generativedesign;

import processing.core.PApplet;
import processing.core.PVector;

public class Node
extends PVector {
    private static final long serialVersionUID = 1L;
    public String id = "";
    public float diameter = 0.0f;
    public float minX = -3.4028235E38f;
    public float maxX = Float.MAX_VALUE;
    public float minY = -3.4028235E38f;
    public float maxY = Float.MAX_VALUE;
    public float minZ = -3.4028235E38f;
    public float maxZ = Float.MAX_VALUE;
    public PVector velocity = new PVector();
    PVector pVelocity = new PVector();
    public float maxVelocity = 10.0f;
    public float damping = 0.5f;
    public float radius = 200.0f;
    public float strength = -1.0f;
    public float ramp = 1.0f;

    public Node() {
    }

    public Node(float f, float f2) {
        this.x = f;
        this.y = f2;
    }

    public Node(float f, float f2, float f3) {
        this.x = f;
        this.y = f2;
        this.z = f3;
    }

    public Node(PVector pVector) {
        this.x = pVector.x;
        this.y = pVector.y;
        this.z = pVector.z;
    }

    public void rotateX(float f) {
        float f2 = this.y * PApplet.cos((float)f) - this.z * PApplet.sin((float)f);
        float f3 = this.y * PApplet.sin((float)f) + this.z * PApplet.cos((float)f);
        this.y = f2;
        this.z = f3;
    }

    public void rotateY(float f) {
        float f2 = this.x * PApplet.cos((float)(-f)) - this.z * PApplet.sin((float)(-f));
        float f3 = this.x * PApplet.sin((float)(-f)) + this.z * PApplet.cos((float)(-f));
        this.x = f2;
        this.z = f3;
    }

    public void rotateZ(float f) {
        float f2 = this.x * PApplet.cos((float)f) - this.y * PApplet.sin((float)f);
        float f3 = this.x * PApplet.sin((float)f) + this.y * PApplet.cos((float)f);
        this.x = f2;
        this.y = f3;
    }

    public void attract(Node[] nodeArray) {
        Node node;
        for (int i = 0; i < nodeArray.length && (node = nodeArray[i]) != null; ++i) {
            if (node == this) continue;
            this.attract(node);
        }
    }

    public void attract(Node node) {
        float f = PVector.dist((PVector)this, (PVector)node);
        if (f > 0.0f && f < this.radius) {
            float f2 = PApplet.pow((float)(f / this.radius), (float)(1.0f / this.ramp));
            float f3 = f2 * 9.0f * this.strength * (1.0f / (f2 + 1.0f) + (f2 - 3.0f) / 4.0f) / f;
            PVector pVector = PVector.sub((PVector)this, (PVector)node);
            pVector.mult(f3);
            node.velocity.x += pVector.x;
            node.velocity.y += pVector.y;
            node.velocity.z += pVector.z;
        }
    }

    public void update() {
        this.update(false, false, false);
    }

    public void update(boolean bl, boolean bl2, boolean bl3) {
        this.velocity.limit(this.maxVelocity);
        this.pVelocity = this.velocity.get();
        if (!bl) {
            this.x += this.velocity.x;
        }
        if (!bl2) {
            this.y += this.velocity.y;
        }
        if (!bl3) {
            this.z += this.velocity.z;
        }
        if (this.x < this.minX) {
            this.x = this.minX - (this.x - this.minX);
            this.velocity.x = -this.velocity.x;
        }
        if (this.x > this.maxX) {
            this.x = this.maxX - (this.x - this.maxX);
            this.velocity.x = -this.velocity.x;
        }
        if (this.y < this.minY) {
            this.y = this.minY - (this.y - this.minY);
            this.velocity.y = -this.velocity.y;
        }
        if (this.y > this.maxY) {
            this.y = this.maxY - (this.y - this.maxY);
            this.velocity.y = -this.velocity.y;
        }
        if (this.z < this.minZ) {
            this.z = this.minZ - (this.z - this.minZ);
            this.velocity.z = -this.velocity.z;
        }
        if (this.z > this.maxZ) {
            this.z = this.maxZ - (this.z - this.maxZ);
            this.velocity.z = -this.velocity.z;
        }
        this.velocity.mult(1.0f - this.damping);
    }

    public String getID() {
        return this.id;
    }

    public void setID(String string) {
        this.id = string;
    }

    public float getDiameter() {
        return this.diameter;
    }

    public void setDiameter(float f) {
        this.diameter = f;
    }

    public void setBoundary(float f, float f2, float f3, float f4, float f5, float f6) {
        this.minX = f;
        this.maxX = f4;
        this.minY = f2;
        this.maxY = f5;
        this.minZ = f3;
        this.maxZ = f6;
    }

    public void setBoundary(float f, float f2, float f3, float f4) {
        this.minX = f;
        this.maxX = f3;
        this.minY = f2;
        this.maxY = f4;
    }

    public float getMinX() {
        return this.minX;
    }

    public void setMinX(float f) {
        this.minX = f;
    }

    public float getMaxX() {
        return this.maxX;
    }

    public void setMaxX(float f) {
        this.maxX = f;
    }

    public float getMinY() {
        return this.minY;
    }

    public void setMinY(float f) {
        this.minY = f;
    }

    public float getMaxY() {
        return this.maxY;
    }

    public void setMaxY(float f) {
        this.maxY = f;
    }

    public float getMinZ() {
        return this.minZ;
    }

    public void setMinZ(float f) {
        this.minZ = f;
    }

    public float getMaxZ() {
        return this.maxZ;
    }

    public void setMaxZ(float f) {
        this.maxZ = f;
    }

    public PVector getVelocity() {
        return this.velocity;
    }

    public void setVelocity(PVector pVector) {
        this.velocity = pVector;
    }

    public float getMaxVelocity() {
        return this.maxVelocity;
    }

    public void setMaxVelocity(float f) {
        this.maxVelocity = f;
    }

    public float getDamping() {
        return this.damping;
    }

    public void setDamping(float f) {
        this.damping = f;
    }

    public float getRadius() {
        return this.radius;
    }

    public void setRadius(float f) {
        this.radius = f;
    }

    public float getStrength() {
        return this.strength;
    }

    public void setStrength(float f) {
        this.strength = f;
    }

    public float getRamp() {
        return this.ramp;
    }

    public void setRamp(float f) {
        this.ramp = f;
    }
}

