/*
 * Decompiled with CFR 0.152.
 */
package generativedesign;

import generativedesign.Node;
import processing.core.PVector;

public class Spring {
    public String id = "";
    public Node fromNode;
    public Node toNode;
    public float length = 100.0f;
    public float stiffness = 0.6f;
    public float damping = 0.9f;

    public Spring(Node node, Node node2) {
        this.fromNode = node;
        this.toNode = node2;
    }

    public Spring(Node node, Node node2, float f, float f2, float f3) {
        this.fromNode = node;
        this.toNode = node2;
        this.length = f;
        this.stiffness = f2;
        this.damping = f3;
    }

    public void update() {
        PVector pVector = PVector.sub((PVector)this.toNode, (PVector)this.fromNode);
        pVector.normalize();
        pVector.mult(this.length);
        PVector pVector2 = PVector.add((PVector)this.fromNode, (PVector)pVector);
        PVector pVector3 = PVector.sub((PVector)pVector2, (PVector)this.toNode);
        pVector3.mult(0.5f);
        pVector3.mult(this.stiffness);
        pVector3.mult(1.0f - this.damping);
        this.toNode.velocity.add(pVector3);
        this.fromNode.velocity.add(PVector.mult((PVector)pVector3, (float)-1.0f));
    }

    public String getID() {
        return this.id;
    }

    public void setID(String string) {
        this.id = string;
    }

    public Node getFromNode() {
        return this.fromNode;
    }

    public void setFromNode(Node node) {
        this.fromNode = node;
    }

    public Node getToNode() {
        return this.toNode;
    }

    public void setToNode(Node node) {
        this.toNode = node;
    }

    public float getLength() {
        return this.length;
    }

    public void setLength(float f) {
        this.length = f;
    }

    public float getStiffness() {
        return this.stiffness;
    }

    public void setStiffness(float f) {
        this.stiffness = f;
    }

    public float getDamping() {
        return this.damping;
    }

    public void setDamping(float f) {
        this.damping = f;
    }
}

