/*
 * Decompiled with CFR 0.152.
 */
package generativedesign;

import java.awt.Component;
import java.lang.reflect.Method;
import jpen.PButton;
import jpen.PButtonEvent;
import jpen.PKind;
import jpen.PKindEvent;
import jpen.PLevel;
import jpen.PLevelEvent;
import jpen.PScrollEvent;
import jpen.PenManager;
import jpen.PenState;
import jpen.PenStateCopy;
import jpen.event.PenListener;
import processing.core.PApplet;

public class Tablet
implements PenListener {
    public static final int UNDEFINED = 0;
    public static final int CURSOR = 1;
    public static final int STYLUS = 2;
    public static final int ERASER = 3;
    protected boolean isMovementEvent;
    protected final PenStateCopy savedPen;
    protected PApplet parent;
    protected PenManager pm;
    protected Method penButtonEventMethod;
    protected Method penKindEventMethod;
    protected Method penLevelEventMethod;
    protected Method penScrollEventMethod;

    public Tablet(PApplet pApplet) {
        this.parent = pApplet;
        this.pm = new PenManager((Component)pApplet);
        this.pm.pen.addListener((PenListener)this);
        this.savedPen = new PenStateCopy();
        try {
            this.penButtonEventMethod = pApplet.getClass().getMethod("penButtonEvent", Tablet.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.penKindEventMethod = pApplet.getClass().getMethod("penKindEvent", Tablet.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.penLevelEventMethod = pApplet.getClass().getMethod("penLevelEvent", Tablet.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.penScrollEventMethod = pApplet.getClass().getMethod("penScrollEvent", Tablet.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public float getPressure() {
        return this.pm.pen.getLevelValue(PLevel.Type.PRESSURE);
    }

    public float getPenX() {
        return this.pm.pen.getLevelValue(PLevel.Type.X);
    }

    public float getPenY() {
        return this.pm.pen.getLevelValue(PLevel.Type.Y);
    }

    public float getTiltX() {
        return this.pm.pen.getLevelValue(PLevel.Type.TILT_X);
    }

    public float getTiltY() {
        return this.pm.pen.getLevelValue(PLevel.Type.TILT_Y);
    }

    public float getAzimuth() {
        double d = this.getTiltX();
        double d2 = this.getTiltY();
        double[] dArray = new double[2];
        PLevel.Type.evalAzimuthXAndAltitude((double[])dArray, (double)d, (double)d2);
        return (float)dArray[0];
    }

    public float getAltitude() {
        double d = this.getTiltX();
        double d2 = this.getTiltY();
        double[] dArray = new double[2];
        PLevel.Type.evalAzimuthXAndAltitude((double[])dArray, (double)d, (double)d2);
        return (float)dArray[1];
    }

    public boolean isMovement() {
        return this.isMovementEvent;
    }

    public int getPenKind() {
        if (this.pm.pen.getKind() == PKind.valueOf((PKind.Type)PKind.Type.CURSOR)) {
            return 1;
        }
        if (this.pm.pen.getKind() == PKind.valueOf((PKind.Type)PKind.Type.STYLUS)) {
            return 2;
        }
        if (this.pm.pen.getKind() == PKind.valueOf((PKind.Type)PKind.Type.ERASER)) {
            return 3;
        }
        return 0;
    }

    public boolean isDown() {
        return this.pm.pen.hasPressedButtons();
    }

    public boolean isCenterDown() {
        return this.pm.pen.getButtonValue(PButton.Type.CENTER);
    }

    public boolean isLeftDown() {
        return this.pm.pen.getButtonValue(PButton.Type.LEFT);
    }

    public boolean isRightDown() {
        return this.pm.pen.getButtonValue(PButton.Type.RIGHT);
    }

    public void saveState() {
        this.savedPen.setValues((PenState)this.pm.pen);
    }

    public float getSavedPressure() {
        return this.savedPen.getLevelValue(PLevel.Type.PRESSURE);
    }

    public float getSavedPenX() {
        return this.savedPen.getLevelValue(PLevel.Type.X);
    }

    public float getSavedPenY() {
        return this.savedPen.getLevelValue(PLevel.Type.Y);
    }

    public float getSavedTiltX() {
        return this.savedPen.getLevelValue(PLevel.Type.TILT_X);
    }

    public float getSavedTiltY() {
        return this.savedPen.getLevelValue(PLevel.Type.TILT_Y);
    }

    public float getSavedAzimuth() {
        double d = this.getSavedTiltX();
        double d2 = this.getSavedTiltY();
        double[] dArray = new double[2];
        PLevel.Type.evalAzimuthXAndAltitude((double[])dArray, (double)d, (double)d2);
        return (float)dArray[0];
    }

    public float getSavedAltitude() {
        double d = this.getSavedTiltX();
        double d2 = this.getSavedTiltY();
        double[] dArray = new double[2];
        PLevel.Type.evalAzimuthXAndAltitude((double[])dArray, (double)d, (double)d2);
        return (float)dArray[1];
    }

    public void penButtonEvent(PButtonEvent pButtonEvent) {
        if (this.penButtonEventMethod != null) {
            try {
                this.penButtonEventMethod.invoke((Object)this.parent, this);
            }
            catch (Exception exception) {
                System.err.println("error, disabling penButtonEvent()");
                exception.printStackTrace();
                this.penButtonEventMethod = null;
            }
        }
    }

    public void penKindEvent(PKindEvent pKindEvent) {
        if (this.penKindEventMethod != null) {
            try {
                this.penKindEventMethod.invoke((Object)this.parent, this);
            }
            catch (Exception exception) {
                System.err.println("error, disabling penKindEvent()");
                exception.printStackTrace();
                this.penKindEventMethod = null;
            }
        }
    }

    public void penLevelEvent(PLevelEvent pLevelEvent) {
        this.isMovementEvent = pLevelEvent.isMovement();
        if (this.penLevelEventMethod != null) {
            try {
                this.penLevelEventMethod.invoke((Object)this.parent, this);
            }
            catch (Exception exception) {
                System.err.println("error, disabling penLevelEvent()");
                exception.printStackTrace();
                this.penLevelEventMethod = null;
            }
        }
    }

    public void penScrollEvent(PScrollEvent pScrollEvent) {
        if (this.penScrollEventMethod != null) {
            try {
                this.penScrollEventMethod.invoke((Object)this.parent, this);
            }
            catch (Exception exception) {
                System.err.println("error, disabling penScrollEvent()");
                exception.printStackTrace();
                this.penScrollEventMethod = null;
            }
        }
    }

    public void penTock(long l) {
    }
}

