/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Image;
import java.util.HashMap;
import java.util.WeakHashMap;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PFont;
import processing.core.PImage;
import processing.core.PMatrix;
import processing.core.PMatrix2D;
import processing.core.PMatrix3D;
import processing.core.PShape;
import processing.core.PStyle;
import processing.opengl.PGL;
import processing.opengl.PShader;

public class PGraphics
extends PImage
implements PConstants {
    public Canvas canvas;
    public int pixelCount;
    public boolean smooth;
    public int quality;
    protected boolean settingsInited;
    protected boolean reapplySettings;
    protected PGraphics raw;
    protected String path;
    protected boolean primarySurface;
    protected boolean[] hints = new boolean[11];
    protected WeakHashMap<PImage, Object> cacheMap = new WeakHashMap();
    public static final int R = 3;
    public static final int G = 4;
    public static final int B = 5;
    public static final int A = 6;
    public static final int U = 7;
    public static final int V = 8;
    public static final int NX = 9;
    public static final int NY = 10;
    public static final int NZ = 11;
    public static final int EDGE = 12;
    public static final int SR = 13;
    public static final int SG = 14;
    public static final int SB = 15;
    public static final int SA = 16;
    public static final int SW = 17;
    public static final int TX = 18;
    public static final int TY = 19;
    public static final int TZ = 20;
    public static final int VX = 21;
    public static final int VY = 22;
    public static final int VZ = 23;
    public static final int VW = 24;
    public static final int AR = 25;
    public static final int AG = 26;
    public static final int AB = 27;
    public static final int DR = 3;
    public static final int DG = 4;
    public static final int DB = 5;
    public static final int DA = 6;
    public static final int SPR = 28;
    public static final int SPG = 29;
    public static final int SPB = 30;
    public static final int SHINE = 31;
    public static final int ER = 32;
    public static final int EG = 33;
    public static final int EB = 34;
    public static final int BEEN_LIT = 35;
    public static final int HAS_NORMAL = 36;
    public static final int VERTEX_FIELD_COUNT = 37;
    public int colorMode;
    public float colorModeX;
    public float colorModeY;
    public float colorModeZ;
    public float colorModeA;
    boolean colorModeScale;
    boolean colorModeDefault;
    public boolean tint;
    public int tintColor;
    protected boolean tintAlpha;
    protected float tintR;
    protected float tintG;
    protected float tintB;
    protected float tintA;
    protected int tintRi;
    protected int tintGi;
    protected int tintBi;
    protected int tintAi;
    public boolean fill;
    public int fillColor = -1;
    protected boolean fillAlpha;
    protected float fillR;
    protected float fillG;
    protected float fillB;
    protected float fillA;
    protected int fillRi;
    protected int fillGi;
    protected int fillBi;
    protected int fillAi;
    public boolean stroke;
    public int strokeColor = -16777216;
    protected boolean strokeAlpha;
    protected float strokeR;
    protected float strokeG;
    protected float strokeB;
    protected float strokeA;
    protected int strokeRi;
    protected int strokeGi;
    protected int strokeBi;
    protected int strokeAi;
    protected static final float DEFAULT_STROKE_WEIGHT = 1.0f;
    protected static final int DEFAULT_STROKE_JOIN = 8;
    protected static final int DEFAULT_STROKE_CAP = 2;
    public float strokeWeight = 1.0f;
    public int strokeJoin = 8;
    public int strokeCap = 2;
    public int rectMode;
    public int ellipseMode;
    public int shapeMode;
    public int imageMode = 0;
    public PFont textFont;
    public int textAlign = 37;
    public int textAlignY = 0;
    public int textMode = 4;
    public float textSize;
    public float textLeading;
    public int ambientColor;
    public float ambientR;
    public float ambientG;
    public float ambientB;
    public boolean setAmbient;
    public int specularColor;
    public float specularR;
    public float specularG;
    public float specularB;
    public int emissiveColor;
    public float emissiveR;
    public float emissiveG;
    public float emissiveB;
    public float shininess;
    static final int STYLE_STACK_DEPTH = 64;
    PStyle[] styleStack = new PStyle[64];
    int styleStackDepth;
    public int backgroundColor = -3355444;
    protected boolean backgroundAlpha;
    protected float backgroundR;
    protected float backgroundG;
    protected float backgroundB;
    protected float backgroundA;
    protected int backgroundRi;
    protected int backgroundGi;
    protected int backgroundBi;
    protected int backgroundAi;
    static final int MATRIX_STACK_DEPTH = 32;
    public Image image;
    protected float calcR;
    protected float calcG;
    protected float calcB;
    protected float calcA;
    protected int calcRi;
    protected int calcGi;
    protected int calcBi;
    protected int calcAi;
    protected int calcColor;
    protected boolean calcAlpha;
    int cacheHsbKey;
    float[] cacheHsbValue = new float[3];
    protected int shape;
    public static final int DEFAULT_VERTICES = 512;
    protected float[][] vertices = new float[512][37];
    protected int vertexCount;
    protected boolean bezierInited = false;
    public int bezierDetail = 20;
    protected PMatrix3D bezierBasisMatrix = new PMatrix3D(-1.0f, 3.0f, -3.0f, 1.0f, 3.0f, -6.0f, 3.0f, 0.0f, -3.0f, 3.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f);
    protected PMatrix3D bezierDrawMatrix;
    protected boolean curveInited = false;
    public int curveDetail = 20;
    public float curveTightness = 0.0f;
    protected PMatrix3D curveBasisMatrix;
    protected PMatrix3D curveDrawMatrix;
    protected PMatrix3D bezierBasisInverse;
    protected PMatrix3D curveToBezierMatrix;
    protected float[][] curveVertices;
    protected int curveVertexCount;
    protected static final float[] sinLUT = new float[720];
    protected static final float[] cosLUT = new float[720];
    protected static final float SINCOS_PRECISION = 0.5f;
    protected static final int SINCOS_LENGTH = 720;
    protected char[] textBuffer = new char[8192];
    protected char[] textWidthBuffer = new char[8192];
    protected int textBreakCount;
    protected int[] textBreakStart;
    protected int[] textBreakStop;
    public boolean edge = true;
    protected static final int NORMAL_MODE_AUTO = 0;
    protected static final int NORMAL_MODE_SHAPE = 1;
    protected static final int NORMAL_MODE_VERTEX = 2;
    protected int normalMode;
    protected boolean autoNormal;
    public float normalX;
    public float normalY;
    public float normalZ;
    public int textureMode = 2;
    public float textureU;
    public float textureV;
    public PImage textureImage;
    protected float[] sphereX;
    protected float[] sphereY;
    protected float[] sphereZ;
    public int sphereDetailU = 0;
    public int sphereDetailV = 0;
    static float[] lerpColorHSB1;
    static float[] lerpColorHSB2;
    protected static HashMap<String, Object> warnings;

    public void setParent(PApplet parent) {
        this.parent = parent;
        this.quality = parent.sketchQuality();
    }

    public void setPrimary(boolean primary) {
        this.primarySurface = primary;
        if (this.primarySurface) {
            this.format = 1;
        }
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setFrameRate(float frameRate) {
    }

    public void setSize(int w, int h) {
        this.width = w;
        this.height = h;
        this.allocate();
        this.reapplySettings();
    }

    protected void allocate() {
    }

    public void dispose() {
    }

    public void setCache(PImage image, Object storage) {
        this.cacheMap.put(image, storage);
    }

    public Object getCache(PImage image) {
        return this.cacheMap.get(image);
    }

    public void removeCache(PImage image) {
        this.cacheMap.remove(image);
    }

    public void requestFocus() {
        if (this.parent != null) {
            this.parent.requestFocusInWindow();
        }
    }

    public boolean canDraw() {
        return true;
    }

    public void requestDraw() {
        this.parent.handleDraw();
    }

    public void beginDraw() {
    }

    public void endDraw() {
    }

    public PGL beginPGL() {
        PGraphics.showMethodWarning("beginGL");
        return null;
    }

    public void endPGL() {
        PGraphics.showMethodWarning("endGL");
    }

    public void flush() {
    }

    protected void checkSettings() {
        if (!this.settingsInited) {
            this.defaultSettings();
        }
        if (this.reapplySettings) {
            this.reapplySettings();
        }
    }

    protected void defaultSettings() {
        if (this.quality > 0) {
            this.smooth();
        } else {
            this.noSmooth();
        }
        this.colorMode(1, 255.0f);
        this.fill(255);
        this.stroke(0);
        this.strokeWeight(1.0f);
        this.strokeJoin(8);
        this.strokeCap(2);
        this.shape = 0;
        this.rectMode(0);
        this.ellipseMode(3);
        this.autoNormal = true;
        this.textFont = null;
        this.textSize = 12.0f;
        this.textLeading = 14.0f;
        this.textAlign = 37;
        this.textMode = 4;
        if (this.primarySurface) {
            this.background(this.backgroundColor);
        }
        this.settingsInited = true;
    }

    protected void reapplySettings() {
        if (!this.settingsInited) {
            return;
        }
        this.colorMode(this.colorMode, this.colorModeX, this.colorModeY, this.colorModeZ);
        if (this.fill) {
            this.fill(this.fillColor);
        } else {
            this.noFill();
        }
        if (this.stroke) {
            this.stroke(this.strokeColor);
            this.strokeWeight(this.strokeWeight);
            this.strokeCap(this.strokeCap);
            this.strokeJoin(this.strokeJoin);
        } else {
            this.noStroke();
        }
        if (this.tint) {
            this.tint(this.tintColor);
        } else {
            this.noTint();
        }
        if (this.smooth) {
            this.smooth();
        } else {
            this.noSmooth();
        }
        if (this.textFont != null) {
            float saveLeading = this.textLeading;
            this.textFont(this.textFont, this.textSize);
            this.textLeading(saveLeading);
        }
        this.textMode(this.textMode);
        this.textAlign(this.textAlign, this.textAlignY);
        this.background(this.backgroundColor);
        this.reapplySettings = false;
    }

    public void hint(int which) {
        if (which == 1 || which == -1) {
            PGraphics.showWarning("hint(ENABLE_NATIVE_FONTS) no longer supported. Use createFont() instead.");
        }
        if (which > 0) {
            this.hints[which] = true;
        } else {
            this.hints[-which] = false;
        }
    }

    public void beginShape() {
        this.beginShape(20);
    }

    public void beginShape(int kind) {
        this.shape = kind;
    }

    public void edge(boolean edge) {
        this.edge = edge;
    }

    public void normal(float nx, float ny, float nz) {
        this.normalX = nx;
        this.normalY = ny;
        this.normalZ = nz;
        if (this.shape != 0) {
            if (this.normalMode == 0) {
                this.normalMode = 1;
            } else if (this.normalMode == 1) {
                this.normalMode = 2;
            }
        }
    }

    public void textureMode(int mode) {
        this.textureMode = mode;
    }

    public void textureWrap(int wrap) {
        PGraphics.showMissingWarning("textureWrap");
    }

    public void texture(PImage image) {
        this.textureImage = image;
    }

    public void noTexture() {
        this.textureImage = null;
    }

    protected void vertexCheck() {
        if (this.vertexCount == this.vertices.length) {
            float[][] temp = new float[this.vertexCount << 1][37];
            System.arraycopy(this.vertices, 0, temp, 0, this.vertexCount);
            this.vertices = temp;
        }
    }

    public void vertex(float x, float y) {
        boolean textured;
        this.vertexCheck();
        float[] vertex = this.vertices[this.vertexCount];
        this.curveVertexCount = 0;
        vertex[0] = x;
        vertex[1] = y;
        vertex[2] = 0.0f;
        vertex[12] = this.edge ? 1.0f : 0.0f;
        boolean bl = textured = this.textureImage != null;
        if (this.fill || textured) {
            if (!textured) {
                vertex[3] = this.fillR;
                vertex[4] = this.fillG;
                vertex[5] = this.fillB;
                vertex[6] = this.fillA;
            } else if (this.tint) {
                vertex[3] = this.tintR;
                vertex[4] = this.tintG;
                vertex[5] = this.tintB;
                vertex[6] = this.tintA;
            } else {
                vertex[3] = 1.0f;
                vertex[4] = 1.0f;
                vertex[5] = 1.0f;
                vertex[6] = 1.0f;
            }
        }
        if (this.stroke) {
            vertex[13] = this.strokeR;
            vertex[14] = this.strokeG;
            vertex[15] = this.strokeB;
            vertex[16] = this.strokeA;
            vertex[17] = this.strokeWeight;
        }
        if (textured) {
            vertex[7] = this.textureU;
            vertex[8] = this.textureV;
        }
        if (this.autoNormal) {
            float norm2 = this.normalX * this.normalX + this.normalY * this.normalY + this.normalZ * this.normalZ;
            if (norm2 < 1.0E-4f) {
                vertex[36] = 0.0f;
            } else {
                if (Math.abs(norm2 - 1.0f) > 1.0E-4f) {
                    float norm = PApplet.sqrt(norm2);
                    this.normalX /= norm;
                    this.normalY /= norm;
                    this.normalZ /= norm;
                }
                vertex[36] = 1.0f;
            }
        } else {
            vertex[36] = 1.0f;
        }
        ++this.vertexCount;
    }

    public void vertex(float x, float y, float z) {
        boolean textured;
        float[] pvertex;
        this.vertexCheck();
        float[] vertex = this.vertices[this.vertexCount];
        if (this.shape == 20 && this.vertexCount > 0 && Math.abs((pvertex = this.vertices[this.vertexCount - 1])[0] - x) < 1.0E-4f && Math.abs(pvertex[1] - y) < 1.0E-4f && Math.abs(pvertex[2] - z) < 1.0E-4f) {
            return;
        }
        this.curveVertexCount = 0;
        vertex[0] = x;
        vertex[1] = y;
        vertex[2] = z;
        vertex[12] = this.edge ? 1.0f : 0.0f;
        boolean bl = textured = this.textureImage != null;
        if (this.fill || textured) {
            if (!textured) {
                vertex[3] = this.fillR;
                vertex[4] = this.fillG;
                vertex[5] = this.fillB;
                vertex[6] = this.fillA;
            } else if (this.tint) {
                vertex[3] = this.tintR;
                vertex[4] = this.tintG;
                vertex[5] = this.tintB;
                vertex[6] = this.tintA;
            } else {
                vertex[3] = 1.0f;
                vertex[4] = 1.0f;
                vertex[5] = 1.0f;
                vertex[6] = 1.0f;
            }
            vertex[25] = this.ambientR;
            vertex[26] = this.ambientG;
            vertex[27] = this.ambientB;
            vertex[28] = this.specularR;
            vertex[29] = this.specularG;
            vertex[30] = this.specularB;
            vertex[31] = this.shininess;
            vertex[32] = this.emissiveR;
            vertex[33] = this.emissiveG;
            vertex[34] = this.emissiveB;
        }
        if (this.stroke) {
            vertex[13] = this.strokeR;
            vertex[14] = this.strokeG;
            vertex[15] = this.strokeB;
            vertex[16] = this.strokeA;
            vertex[17] = this.strokeWeight;
        }
        if (textured) {
            vertex[7] = this.textureU;
            vertex[8] = this.textureV;
        }
        if (this.autoNormal) {
            float norm2 = this.normalX * this.normalX + this.normalY * this.normalY + this.normalZ * this.normalZ;
            if (norm2 < 1.0E-4f) {
                vertex[36] = 0.0f;
            } else {
                if (Math.abs(norm2 - 1.0f) > 1.0E-4f) {
                    float norm = PApplet.sqrt(norm2);
                    this.normalX /= norm;
                    this.normalY /= norm;
                    this.normalZ /= norm;
                }
                vertex[36] = 1.0f;
            }
        } else {
            vertex[36] = 1.0f;
        }
        vertex[9] = this.normalX;
        vertex[10] = this.normalY;
        vertex[11] = this.normalZ;
        vertex[35] = 0.0f;
        ++this.vertexCount;
    }

    public void vertex(float[] v) {
        this.vertexCheck();
        this.curveVertexCount = 0;
        float[] vertex = this.vertices[this.vertexCount];
        System.arraycopy(v, 0, vertex, 0, 37);
        ++this.vertexCount;
    }

    public void vertex(float x, float y, float u, float v) {
        this.vertexTexture(u, v);
        this.vertex(x, y);
    }

    public void vertex(float x, float y, float z, float u, float v) {
        this.vertexTexture(u, v);
        this.vertex(x, y, z);
    }

    protected void vertexTexture(float u, float v) {
        if (this.textureImage == null) {
            throw new RuntimeException("You must first call texture() before using u and v coordinates with vertex()");
        }
        if (this.textureMode == 2) {
            u /= (float)this.textureImage.width;
            v /= (float)this.textureImage.height;
        }
        this.textureU = u;
        this.textureV = v;
        if (this.textureU < 0.0f) {
            this.textureU = 0.0f;
        } else if (this.textureU > 1.0f) {
            this.textureU = 1.0f;
        }
        if (this.textureV < 0.0f) {
            this.textureV = 0.0f;
        } else if (this.textureV > 1.0f) {
            this.textureV = 1.0f;
        }
    }

    public void beginContour() {
        PGraphics.showMissingWarning("beginContour");
    }

    public void endContour() {
        PGraphics.showMissingWarning("endContour");
    }

    public void endShape() {
        this.endShape(1);
    }

    public void endShape(int mode) {
    }

    public PShape loadShape(String filename) {
        return this.loadShape(filename, null);
    }

    public PShape loadShape(String filename, String options) {
        PGraphics.showMissingWarning("loadShape");
        return null;
    }

    public PShape createShape() {
        PGraphics.showMissingWarning("createShape");
        return null;
    }

    public PShape createShape(PShape source) {
        PGraphics.showMissingWarning("createShape");
        return null;
    }

    public PShape createShape(int type) {
        PGraphics.showMissingWarning("createShape");
        return null;
    }

    public PShape createShape(int kind, float ... p) {
        PGraphics.showMissingWarning("createShape");
        return null;
    }

    public PShader loadShader(String fragFilename) {
        PGraphics.showMissingWarning("loadShader");
        return null;
    }

    public PShader loadShader(String fragFilename, String vertFilename) {
        PGraphics.showMissingWarning("loadShader");
        return null;
    }

    public void shader(PShader shader) {
        PGraphics.showMissingWarning("shader");
    }

    public void shader(PShader shader, int kind) {
        PGraphics.showMissingWarning("shader");
    }

    public void resetShader() {
        PGraphics.showMissingWarning("resetShader");
    }

    public void resetShader(int kind) {
        PGraphics.showMissingWarning("resetShader");
    }

    public void filter(PShader shader) {
        PGraphics.showMissingWarning("filter");
    }

    public void clip(float a, float b, float c, float d) {
        if (this.imageMode == 0) {
            if (c < 0.0f) {
                a += c;
                c = -c;
            }
            if (d < 0.0f) {
                b += d;
                d = -d;
            }
            this.clipImpl(a, b, a + c, b + d);
        } else if (this.imageMode == 1) {
            float temp;
            if (c < a) {
                temp = a;
                a = c;
                c = temp;
            }
            if (d < b) {
                temp = b;
                b = d;
                d = temp;
            }
            this.clipImpl(a, b, c, d);
        } else if (this.imageMode == 3) {
            if (c < 0.0f) {
                c = -c;
            }
            if (d < 0.0f) {
                d = -d;
            }
            float x1 = a - c / 2.0f;
            float y1 = b - d / 2.0f;
            this.clipImpl(x1, y1, x1 + c, y1 + d);
        }
    }

    protected void clipImpl(float x1, float y1, float x2, float y2) {
        PGraphics.showMissingWarning("clip");
    }

    public void noClip() {
        PGraphics.showMissingWarning("noClip");
    }

    public void blendMode(int mode) {
        PGraphics.showMissingWarning("blendMode");
    }

    protected void bezierVertexCheck() {
        this.bezierVertexCheck(this.shape, this.vertexCount);
    }

    protected void bezierVertexCheck(int shape, int vertexCount) {
        if (shape == 0 || shape != 20) {
            throw new RuntimeException("beginShape() or beginShape(POLYGON) must be used before bezierVertex() or quadraticVertex()");
        }
        if (vertexCount == 0) {
            throw new RuntimeException("vertex() must be used at least oncebefore bezierVertex() or quadraticVertex()");
        }
    }

    public void bezierVertex(float x2, float y2, float x3, float y3, float x4, float y4) {
        this.bezierInitCheck();
        this.bezierVertexCheck();
        PMatrix3D draw = this.bezierDrawMatrix;
        float[] prev = this.vertices[this.vertexCount - 1];
        float x1 = prev[0];
        float y1 = prev[1];
        float xplot1 = draw.m10 * x1 + draw.m11 * x2 + draw.m12 * x3 + draw.m13 * x4;
        float xplot2 = draw.m20 * x1 + draw.m21 * x2 + draw.m22 * x3 + draw.m23 * x4;
        float xplot3 = draw.m30 * x1 + draw.m31 * x2 + draw.m32 * x3 + draw.m33 * x4;
        float yplot1 = draw.m10 * y1 + draw.m11 * y2 + draw.m12 * y3 + draw.m13 * y4;
        float yplot2 = draw.m20 * y1 + draw.m21 * y2 + draw.m22 * y3 + draw.m23 * y4;
        float yplot3 = draw.m30 * y1 + draw.m31 * y2 + draw.m32 * y3 + draw.m33 * y4;
        for (int j = 0; j < this.bezierDetail; ++j) {
            xplot1 += xplot2;
            xplot2 += xplot3;
            yplot2 += yplot3;
            this.vertex(x1 += xplot1, y1 += (yplot1 += yplot2));
        }
    }

    public void bezierVertex(float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4) {
        this.bezierInitCheck();
        this.bezierVertexCheck();
        PMatrix3D draw = this.bezierDrawMatrix;
        float[] prev = this.vertices[this.vertexCount - 1];
        float x1 = prev[0];
        float y1 = prev[1];
        float z1 = prev[2];
        float xplot1 = draw.m10 * x1 + draw.m11 * x2 + draw.m12 * x3 + draw.m13 * x4;
        float xplot2 = draw.m20 * x1 + draw.m21 * x2 + draw.m22 * x3 + draw.m23 * x4;
        float xplot3 = draw.m30 * x1 + draw.m31 * x2 + draw.m32 * x3 + draw.m33 * x4;
        float yplot1 = draw.m10 * y1 + draw.m11 * y2 + draw.m12 * y3 + draw.m13 * y4;
        float yplot2 = draw.m20 * y1 + draw.m21 * y2 + draw.m22 * y3 + draw.m23 * y4;
        float yplot3 = draw.m30 * y1 + draw.m31 * y2 + draw.m32 * y3 + draw.m33 * y4;
        float zplot1 = draw.m10 * z1 + draw.m11 * z2 + draw.m12 * z3 + draw.m13 * z4;
        float zplot2 = draw.m20 * z1 + draw.m21 * z2 + draw.m22 * z3 + draw.m23 * z4;
        float zplot3 = draw.m30 * z1 + draw.m31 * z2 + draw.m32 * z3 + draw.m33 * z4;
        for (int j = 0; j < this.bezierDetail; ++j) {
            x1 += xplot1;
            xplot1 += xplot2;
            xplot2 += xplot3;
            yplot1 += yplot2;
            yplot2 += yplot3;
            zplot2 += zplot3;
            this.vertex(x1, y1 += yplot1, z1 += (zplot1 += zplot2));
        }
    }

    public void quadraticVertex(float cx, float cy, float x3, float y3) {
        float[] prev = this.vertices[this.vertexCount - 1];
        float x1 = prev[0];
        float y1 = prev[1];
        this.bezierVertex(x1 + (cx - x1) * 2.0f / 3.0f, y1 + (cy - y1) * 2.0f / 3.0f, x3 + (cx - x3) * 2.0f / 3.0f, y3 + (cy - y3) * 2.0f / 3.0f, x3, y3);
    }

    public void quadraticVertex(float cx, float cy, float cz, float x3, float y3, float z3) {
        float[] prev = this.vertices[this.vertexCount - 1];
        float x1 = prev[0];
        float y1 = prev[1];
        float z1 = prev[2];
        this.bezierVertex(x1 + (cx - x1) * 2.0f / 3.0f, y1 + (cy - y1) * 2.0f / 3.0f, z1 + (cz - z1) * 2.0f / 3.0f, x3 + (cx - x3) * 2.0f / 3.0f, y3 + (cy - y3) * 2.0f / 3.0f, z3 + (cz - z3) * 2.0f / 3.0f, x3, y3, z3);
    }

    protected void curveVertexCheck() {
        this.curveVertexCheck(this.shape);
    }

    protected void curveVertexCheck(int shape) {
        if (shape != 20) {
            throw new RuntimeException("You must use beginShape() or beginShape(POLYGON) before curveVertex()");
        }
        if (this.curveVertices == null) {
            this.curveVertices = new float[128][3];
        }
        if (this.curveVertexCount == this.curveVertices.length) {
            float[][] temp = new float[this.curveVertexCount << 1][3];
            System.arraycopy(this.curveVertices, 0, temp, 0, this.curveVertexCount);
            this.curveVertices = temp;
        }
        this.curveInitCheck();
    }

    public void curveVertex(float x, float y) {
        this.curveVertexCheck();
        float[] vertex = this.curveVertices[this.curveVertexCount];
        vertex[0] = x;
        vertex[1] = y;
        ++this.curveVertexCount;
        if (this.curveVertexCount > 3) {
            this.curveVertexSegment(this.curveVertices[this.curveVertexCount - 4][0], this.curveVertices[this.curveVertexCount - 4][1], this.curveVertices[this.curveVertexCount - 3][0], this.curveVertices[this.curveVertexCount - 3][1], this.curveVertices[this.curveVertexCount - 2][0], this.curveVertices[this.curveVertexCount - 2][1], this.curveVertices[this.curveVertexCount - 1][0], this.curveVertices[this.curveVertexCount - 1][1]);
        }
    }

    public void curveVertex(float x, float y, float z) {
        this.curveVertexCheck();
        float[] vertex = this.curveVertices[this.curveVertexCount];
        vertex[0] = x;
        vertex[1] = y;
        vertex[2] = z;
        ++this.curveVertexCount;
        if (this.curveVertexCount > 3) {
            this.curveVertexSegment(this.curveVertices[this.curveVertexCount - 4][0], this.curveVertices[this.curveVertexCount - 4][1], this.curveVertices[this.curveVertexCount - 4][2], this.curveVertices[this.curveVertexCount - 3][0], this.curveVertices[this.curveVertexCount - 3][1], this.curveVertices[this.curveVertexCount - 3][2], this.curveVertices[this.curveVertexCount - 2][0], this.curveVertices[this.curveVertexCount - 2][1], this.curveVertices[this.curveVertexCount - 2][2], this.curveVertices[this.curveVertexCount - 1][0], this.curveVertices[this.curveVertexCount - 1][1], this.curveVertices[this.curveVertexCount - 1][2]);
        }
    }

    protected void curveVertexSegment(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        float x0 = x2;
        float y0 = y2;
        PMatrix3D draw = this.curveDrawMatrix;
        float xplot1 = draw.m10 * x1 + draw.m11 * x2 + draw.m12 * x3 + draw.m13 * x4;
        float xplot2 = draw.m20 * x1 + draw.m21 * x2 + draw.m22 * x3 + draw.m23 * x4;
        float xplot3 = draw.m30 * x1 + draw.m31 * x2 + draw.m32 * x3 + draw.m33 * x4;
        float yplot1 = draw.m10 * y1 + draw.m11 * y2 + draw.m12 * y3 + draw.m13 * y4;
        float yplot2 = draw.m20 * y1 + draw.m21 * y2 + draw.m22 * y3 + draw.m23 * y4;
        float yplot3 = draw.m30 * y1 + draw.m31 * y2 + draw.m32 * y3 + draw.m33 * y4;
        int savedCount = this.curveVertexCount;
        this.vertex(x0, y0);
        for (int j = 0; j < this.curveDetail; ++j) {
            xplot1 += xplot2;
            xplot2 += xplot3;
            yplot2 += yplot3;
            this.vertex(x0 += xplot1, y0 += (yplot1 += yplot2));
        }
        this.curveVertexCount = savedCount;
    }

    protected void curveVertexSegment(float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4) {
        float x0 = x2;
        float y0 = y2;
        float z0 = z2;
        PMatrix3D draw = this.curveDrawMatrix;
        float xplot1 = draw.m10 * x1 + draw.m11 * x2 + draw.m12 * x3 + draw.m13 * x4;
        float xplot2 = draw.m20 * x1 + draw.m21 * x2 + draw.m22 * x3 + draw.m23 * x4;
        float xplot3 = draw.m30 * x1 + draw.m31 * x2 + draw.m32 * x3 + draw.m33 * x4;
        float yplot1 = draw.m10 * y1 + draw.m11 * y2 + draw.m12 * y3 + draw.m13 * y4;
        float yplot2 = draw.m20 * y1 + draw.m21 * y2 + draw.m22 * y3 + draw.m23 * y4;
        float yplot3 = draw.m30 * y1 + draw.m31 * y2 + draw.m32 * y3 + draw.m33 * y4;
        int savedCount = this.curveVertexCount;
        float zplot1 = draw.m10 * z1 + draw.m11 * z2 + draw.m12 * z3 + draw.m13 * z4;
        float zplot2 = draw.m20 * z1 + draw.m21 * z2 + draw.m22 * z3 + draw.m23 * z4;
        float zplot3 = draw.m30 * z1 + draw.m31 * z2 + draw.m32 * z3 + draw.m33 * z4;
        this.vertex(x0, y0, z0);
        for (int j = 0; j < this.curveDetail; ++j) {
            x0 += xplot1;
            xplot1 += xplot2;
            xplot2 += xplot3;
            yplot1 += yplot2;
            yplot2 += yplot3;
            zplot2 += zplot3;
            this.vertex(x0, y0 += yplot1, z0 += (zplot1 += zplot2));
        }
        this.curveVertexCount = savedCount;
    }

    public void point(float x, float y) {
        this.beginShape(3);
        this.vertex(x, y);
        this.endShape();
    }

    public void point(float x, float y, float z) {
        this.beginShape(3);
        this.vertex(x, y, z);
        this.endShape();
    }

    public void line(float x1, float y1, float x2, float y2) {
        this.beginShape(5);
        this.vertex(x1, y1);
        this.vertex(x2, y2);
        this.endShape();
    }

    public void line(float x1, float y1, float z1, float x2, float y2, float z2) {
        this.beginShape(5);
        this.vertex(x1, y1, z1);
        this.vertex(x2, y2, z2);
        this.endShape();
    }

    public void triangle(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.beginShape(9);
        this.vertex(x1, y1);
        this.vertex(x2, y2);
        this.vertex(x3, y3);
        this.endShape();
    }

    public void quad(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        this.beginShape(17);
        this.vertex(x1, y1);
        this.vertex(x2, y2);
        this.vertex(x3, y3);
        this.vertex(x4, y4);
        this.endShape();
    }

    public void rectMode(int mode) {
        this.rectMode = mode;
    }

    public void rect(float a, float b, float c, float d) {
        float temp;
        switch (this.rectMode) {
            case 1: {
                break;
            }
            case 0: {
                c += a;
                d += b;
                break;
            }
            case 2: {
                float hradius = c;
                float vradius = d;
                c = a + hradius;
                d = b + vradius;
                a -= hradius;
                b -= vradius;
                break;
            }
            case 3: {
                float hradius = c / 2.0f;
                float vradius = d / 2.0f;
                c = a + hradius;
                d = b + vradius;
                a -= hradius;
                b -= vradius;
            }
        }
        if (a > c) {
            temp = a;
            a = c;
            c = temp;
        }
        if (b > d) {
            temp = b;
            b = d;
            d = temp;
        }
        this.rectImpl(a, b, c, d);
    }

    protected void rectImpl(float x1, float y1, float x2, float y2) {
        this.quad(x1, y1, x2, y1, x2, y2, x1, y2);
    }

    public void rect(float a, float b, float c, float d, float r) {
        this.rect(a, b, c, d, r, r, r, r);
    }

    public void rect(float a, float b, float c, float d, float tl, float tr, float br, float bl) {
        float maxRounding;
        float temp;
        switch (this.rectMode) {
            case 1: {
                break;
            }
            case 0: {
                c += a;
                d += b;
                break;
            }
            case 2: {
                float hradius = c;
                float vradius = d;
                c = a + hradius;
                d = b + vradius;
                a -= hradius;
                b -= vradius;
                break;
            }
            case 3: {
                float hradius = c / 2.0f;
                float vradius = d / 2.0f;
                c = a + hradius;
                d = b + vradius;
                a -= hradius;
                b -= vradius;
            }
        }
        if (a > c) {
            temp = a;
            a = c;
            c = temp;
        }
        if (b > d) {
            temp = b;
            b = d;
            d = temp;
        }
        if (tl > (maxRounding = PApplet.min((c - a) / 2.0f, (d - b) / 2.0f))) {
            tl = maxRounding;
        }
        if (tr > maxRounding) {
            tr = maxRounding;
        }
        if (br > maxRounding) {
            br = maxRounding;
        }
        if (bl > maxRounding) {
            bl = maxRounding;
        }
        this.rectImpl(a, b, c, d, tl, tr, br, bl);
    }

    protected void rectImpl(float x1, float y1, float x2, float y2, float tl, float tr, float br, float bl) {
        this.beginShape();
        if (tr != 0.0f) {
            this.vertex(x2 - tr, y1);
            this.quadraticVertex(x2, y1, x2, y1 + tr);
        } else {
            this.vertex(x2, y1);
        }
        if (br != 0.0f) {
            this.vertex(x2, y2 - br);
            this.quadraticVertex(x2, y2, x2 - br, y2);
        } else {
            this.vertex(x2, y2);
        }
        if (bl != 0.0f) {
            this.vertex(x1 + bl, y2);
            this.quadraticVertex(x1, y2, x1, y2 - bl);
        } else {
            this.vertex(x1, y2);
        }
        if (tl != 0.0f) {
            this.vertex(x1, y1 + tl);
            this.quadraticVertex(x1, y1, x1 + tl, y1);
        } else {
            this.vertex(x1, y1);
        }
        this.endShape(2);
    }

    public void ellipseMode(int mode) {
        this.ellipseMode = mode;
    }

    public void ellipse(float a, float b, float c, float d) {
        float x = a;
        float y = b;
        float w = c;
        float h = d;
        if (this.ellipseMode == 1) {
            w = c - a;
            h = d - b;
        } else if (this.ellipseMode == 2) {
            x = a - c;
            y = b - d;
            w = c * 2.0f;
            h = d * 2.0f;
        } else if (this.ellipseMode == 3) {
            x = a - c / 2.0f;
            y = b - d / 2.0f;
        }
        if (w < 0.0f) {
            x += w;
            w = -w;
        }
        if (h < 0.0f) {
            y += h;
            h = -h;
        }
        this.ellipseImpl(x, y, w, h);
    }

    protected void ellipseImpl(float x, float y, float w, float h) {
    }

    public void arc(float a, float b, float c, float d, float start, float stop) {
        this.arc(a, b, c, d, start, stop, 0);
    }

    public void arc(float a, float b, float c, float d, float start, float stop, int mode) {
        float x = a;
        float y = b;
        float w = c;
        float h = d;
        if (this.ellipseMode == 1) {
            w = c - a;
            h = d - b;
        } else if (this.ellipseMode == 2) {
            x = a - c;
            y = b - d;
            w = c * 2.0f;
            h = d * 2.0f;
        } else if (this.ellipseMode == 3) {
            x = a - c / 2.0f;
            y = b - d / 2.0f;
        }
        if (!Float.isInfinite(start) && !Float.isInfinite(stop) && stop > start) {
            while (start < 0.0f) {
                start += (float)Math.PI * 2;
                stop += (float)Math.PI * 2;
            }
            if (stop - start > (float)Math.PI * 2) {
                start = 0.0f;
                stop = (float)Math.PI * 2;
            }
            this.arcImpl(x, y, w, h, start, stop, mode);
        }
    }

    protected void arcImpl(float x, float y, float w, float h, float start, float stop, int mode) {
        PGraphics.showMissingWarning("arc");
    }

    public void box(float size) {
        this.box(size, size, size);
    }

    public void box(float w, float h, float d) {
        float x1 = -w / 2.0f;
        float x2 = w / 2.0f;
        float y1 = -h / 2.0f;
        float y2 = h / 2.0f;
        float z1 = -d / 2.0f;
        float z2 = d / 2.0f;
        this.beginShape(17);
        this.normal(0.0f, 0.0f, 1.0f);
        this.vertex(x1, y1, z1);
        this.vertex(x2, y1, z1);
        this.vertex(x2, y2, z1);
        this.vertex(x1, y2, z1);
        this.normal(1.0f, 0.0f, 0.0f);
        this.vertex(x2, y1, z1);
        this.vertex(x2, y1, z2);
        this.vertex(x2, y2, z2);
        this.vertex(x2, y2, z1);
        this.normal(0.0f, 0.0f, -1.0f);
        this.vertex(x2, y1, z2);
        this.vertex(x1, y1, z2);
        this.vertex(x1, y2, z2);
        this.vertex(x2, y2, z2);
        this.normal(-1.0f, 0.0f, 0.0f);
        this.vertex(x1, y1, z2);
        this.vertex(x1, y1, z1);
        this.vertex(x1, y2, z1);
        this.vertex(x1, y2, z2);
        this.normal(0.0f, 1.0f, 0.0f);
        this.vertex(x1, y1, z2);
        this.vertex(x2, y1, z2);
        this.vertex(x2, y1, z1);
        this.vertex(x1, y1, z1);
        this.normal(0.0f, -1.0f, 0.0f);
        this.vertex(x1, y2, z1);
        this.vertex(x2, y2, z1);
        this.vertex(x2, y2, z2);
        this.vertex(x1, y2, z2);
        this.endShape();
    }

    public void sphereDetail(int res) {
        this.sphereDetail(res, res);
    }

    public void sphereDetail(int ures, int vres) {
        float angle_step;
        if (ures < 3) {
            ures = 3;
        }
        if (vres < 2) {
            vres = 2;
        }
        if (ures == this.sphereDetailU && vres == this.sphereDetailV) {
            return;
        }
        float delta = 720.0f / (float)ures;
        float[] cx = new float[ures];
        float[] cz = new float[ures];
        for (int i = 0; i < ures; ++i) {
            cx[i] = cosLUT[(int)((float)i * delta) % 720];
            cz[i] = sinLUT[(int)((float)i * delta) % 720];
        }
        int vertCount = ures * (vres - 1) + 2;
        int currVert = 0;
        this.sphereX = new float[vertCount];
        this.sphereY = new float[vertCount];
        this.sphereZ = new float[vertCount];
        float angle = angle_step = 360.0f / (float)vres;
        for (int i = 1; i < vres; ++i) {
            float curradius = sinLUT[(int)angle % 720];
            float currY = cosLUT[(int)angle % 720];
            for (int j = 0; j < ures; ++j) {
                this.sphereX[currVert] = cx[j] * curradius;
                this.sphereY[currVert] = currY;
                this.sphereZ[currVert++] = cz[j] * curradius;
            }
            angle += angle_step;
        }
        this.sphereDetailU = ures;
        this.sphereDetailV = vres;
    }

    public void sphere(float r) {
        int v2;
        int i;
        if (this.sphereDetailU < 3 || this.sphereDetailV < 2) {
            this.sphereDetail(30);
        }
        this.edge(false);
        this.beginShape(10);
        for (int i2 = 0; i2 < this.sphereDetailU; ++i2) {
            this.normal(0.0f, -1.0f, 0.0f);
            this.vertex(0.0f, -r, 0.0f);
            this.normal(this.sphereX[i2], this.sphereY[i2], this.sphereZ[i2]);
            this.vertex(r * this.sphereX[i2], r * this.sphereY[i2], r * this.sphereZ[i2]);
        }
        this.normal(0.0f, -r, 0.0f);
        this.vertex(0.0f, -r, 0.0f);
        this.normal(this.sphereX[0], this.sphereY[0], this.sphereZ[0]);
        this.vertex(r * this.sphereX[0], r * this.sphereY[0], r * this.sphereZ[0]);
        this.endShape();
        int voff = 0;
        for (i = 2; i < this.sphereDetailV; ++i) {
            int v11;
            int v1 = v11 = voff;
            v2 = voff += this.sphereDetailU;
            this.beginShape(10);
            for (int j = 0; j < this.sphereDetailU; ++j) {
                this.normal(this.sphereX[v1], this.sphereY[v1], this.sphereZ[v1]);
                this.vertex(r * this.sphereX[v1], r * this.sphereY[v1], r * this.sphereZ[v1++]);
                this.normal(this.sphereX[v2], this.sphereY[v2], this.sphereZ[v2]);
                this.vertex(r * this.sphereX[v2], r * this.sphereY[v2], r * this.sphereZ[v2++]);
            }
            v1 = v11;
            v2 = voff;
            this.normal(this.sphereX[v1], this.sphereY[v1], this.sphereZ[v1]);
            this.vertex(r * this.sphereX[v1], r * this.sphereY[v1], r * this.sphereZ[v1]);
            this.normal(this.sphereX[v2], this.sphereY[v2], this.sphereZ[v2]);
            this.vertex(r * this.sphereX[v2], r * this.sphereY[v2], r * this.sphereZ[v2]);
            this.endShape();
        }
        this.beginShape(10);
        for (i = 0; i < this.sphereDetailU; ++i) {
            v2 = voff + i;
            this.normal(this.sphereX[v2], this.sphereY[v2], this.sphereZ[v2]);
            this.vertex(r * this.sphereX[v2], r * this.sphereY[v2], r * this.sphereZ[v2]);
            this.normal(0.0f, 1.0f, 0.0f);
            this.vertex(0.0f, r, 0.0f);
        }
        this.normal(this.sphereX[voff], this.sphereY[voff], this.sphereZ[voff]);
        this.vertex(r * this.sphereX[voff], r * this.sphereY[voff], r * this.sphereZ[voff]);
        this.normal(0.0f, 1.0f, 0.0f);
        this.vertex(0.0f, r, 0.0f);
        this.endShape();
        this.edge(true);
    }

    public float bezierPoint(float a, float b, float c, float d, float t) {
        float t1 = 1.0f - t;
        return a * t1 * t1 * t1 + 3.0f * b * t * t1 * t1 + 3.0f * c * t * t * t1 + d * t * t * t;
    }

    public float bezierTangent(float a, float b, float c, float d, float t) {
        return 3.0f * t * t * (-a + 3.0f * b - 3.0f * c + d) + 6.0f * t * (a - 2.0f * b + c) + 3.0f * (-a + b);
    }

    protected void bezierInitCheck() {
        if (!this.bezierInited) {
            this.bezierInit();
        }
    }

    protected void bezierInit() {
        this.bezierDetail(this.bezierDetail);
        this.bezierInited = true;
    }

    public void bezierDetail(int detail) {
        this.bezierDetail = detail;
        if (this.bezierDrawMatrix == null) {
            this.bezierDrawMatrix = new PMatrix3D();
        }
        this.splineForward(detail, this.bezierDrawMatrix);
        this.bezierDrawMatrix.apply(this.bezierBasisMatrix);
    }

    public void bezier(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        this.beginShape();
        this.vertex(x1, y1);
        this.bezierVertex(x2, y2, x3, y3, x4, y4);
        this.endShape();
    }

    public void bezier(float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4) {
        this.beginShape();
        this.vertex(x1, y1, z1);
        this.bezierVertex(x2, y2, z2, x3, y3, z3, x4, y4, z4);
        this.endShape();
    }

    public float curvePoint(float a, float b, float c, float d, float t) {
        this.curveInitCheck();
        float tt = t * t;
        float ttt = t * tt;
        PMatrix3D cb = this.curveBasisMatrix;
        return a * (ttt * cb.m00 + tt * cb.m10 + t * cb.m20 + cb.m30) + b * (ttt * cb.m01 + tt * cb.m11 + t * cb.m21 + cb.m31) + c * (ttt * cb.m02 + tt * cb.m12 + t * cb.m22 + cb.m32) + d * (ttt * cb.m03 + tt * cb.m13 + t * cb.m23 + cb.m33);
    }

    public float curveTangent(float a, float b, float c, float d, float t) {
        this.curveInitCheck();
        float tt3 = t * t * 3.0f;
        float t2 = t * 2.0f;
        PMatrix3D cb = this.curveBasisMatrix;
        return a * (tt3 * cb.m00 + t2 * cb.m10 + cb.m20) + b * (tt3 * cb.m01 + t2 * cb.m11 + cb.m21) + c * (tt3 * cb.m02 + t2 * cb.m12 + cb.m22) + d * (tt3 * cb.m03 + t2 * cb.m13 + cb.m23);
    }

    public void curveDetail(int detail) {
        this.curveDetail = detail;
        this.curveInit();
    }

    public void curveTightness(float tightness) {
        this.curveTightness = tightness;
        this.curveInit();
    }

    protected void curveInitCheck() {
        if (!this.curveInited) {
            this.curveInit();
        }
    }

    protected void curveInit() {
        if (this.curveDrawMatrix == null) {
            this.curveBasisMatrix = new PMatrix3D();
            this.curveDrawMatrix = new PMatrix3D();
            this.curveInited = true;
        }
        float s = this.curveTightness;
        this.curveBasisMatrix.set((s - 1.0f) / 2.0f, (s + 3.0f) / 2.0f, (-3.0f - s) / 2.0f, (1.0f - s) / 2.0f, 1.0f - s, (-5.0f - s) / 2.0f, s + 2.0f, (s - 1.0f) / 2.0f, (s - 1.0f) / 2.0f, 0.0f, (1.0f - s) / 2.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        this.splineForward(this.curveDetail, this.curveDrawMatrix);
        if (this.bezierBasisInverse == null) {
            this.bezierBasisInverse = this.bezierBasisMatrix.get();
            this.bezierBasisInverse.invert();
            this.curveToBezierMatrix = new PMatrix3D();
        }
        this.curveToBezierMatrix.set(this.curveBasisMatrix);
        this.curveToBezierMatrix.preApply(this.bezierBasisInverse);
        this.curveDrawMatrix.apply(this.curveBasisMatrix);
    }

    public void curve(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        this.beginShape();
        this.curveVertex(x1, y1);
        this.curveVertex(x2, y2);
        this.curveVertex(x3, y3);
        this.curveVertex(x4, y4);
        this.endShape();
    }

    public void curve(float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4) {
        this.beginShape();
        this.curveVertex(x1, y1, z1);
        this.curveVertex(x2, y2, z2);
        this.curveVertex(x3, y3, z3);
        this.curveVertex(x4, y4, z4);
        this.endShape();
    }

    protected void splineForward(int segments, PMatrix3D matrix) {
        float f = 1.0f / (float)segments;
        float ff = f * f;
        float fff = ff * f;
        matrix.set(0.0f, 0.0f, 0.0f, 1.0f, fff, ff, f, 0.0f, 6.0f * fff, 2.0f * ff, 0.0f, 0.0f, 6.0f * fff, 0.0f, 0.0f, 0.0f);
    }

    public void smooth() {
        this.smooth = true;
    }

    public void smooth(int level) {
        this.smooth = true;
    }

    public void noSmooth() {
        this.smooth = false;
    }

    public void imageMode(int mode) {
        if (mode != 0 && mode != 1 && mode != 3) {
            String msg = "imageMode() only works with CORNER, CORNERS, or CENTER";
            throw new RuntimeException(msg);
        }
        this.imageMode = mode;
    }

    public void image(PImage img, float a, float b) {
        if (img.width == -1 || img.height == -1) {
            return;
        }
        if (this.imageMode == 0 || this.imageMode == 1) {
            this.imageImpl(img, a, b, a + (float)img.width, b + (float)img.height, 0, 0, img.width, img.height);
        } else if (this.imageMode == 3) {
            float x1 = a - (float)(img.width / 2);
            float y1 = b - (float)(img.height / 2);
            this.imageImpl(img, x1, y1, x1 + (float)img.width, y1 + (float)img.height, 0, 0, img.width, img.height);
        }
    }

    public void image(PImage img, float a, float b, float c, float d) {
        this.image(img, a, b, c, d, 0, 0, img.width, img.height);
    }

    public void image(PImage img, float a, float b, float c, float d, int u1, int v1, int u2, int v2) {
        if (img.width == -1 || img.height == -1) {
            return;
        }
        if (this.imageMode == 0) {
            if (c < 0.0f) {
                a += c;
                c = -c;
            }
            if (d < 0.0f) {
                b += d;
                d = -d;
            }
            this.imageImpl(img, a, b, a + c, b + d, u1, v1, u2, v2);
        } else if (this.imageMode == 1) {
            float temp;
            if (c < a) {
                temp = a;
                a = c;
                c = temp;
            }
            if (d < b) {
                temp = b;
                b = d;
                d = temp;
            }
            this.imageImpl(img, a, b, c, d, u1, v1, u2, v2);
        } else if (this.imageMode == 3) {
            if (c < 0.0f) {
                c = -c;
            }
            if (d < 0.0f) {
                d = -d;
            }
            float x1 = a - c / 2.0f;
            float y1 = b - d / 2.0f;
            this.imageImpl(img, x1, y1, x1 + c, y1 + d, u1, v1, u2, v2);
        }
    }

    protected void imageImpl(PImage img, float x1, float y1, float x2, float y2, int u1, int v1, int u2, int v2) {
        boolean savedStroke = this.stroke;
        int savedTextureMode = this.textureMode;
        this.stroke = false;
        this.textureMode = 2;
        this.beginShape(17);
        this.texture(img);
        this.vertex(x1, y1, u1, v1);
        this.vertex(x1, y2, u1, v2);
        this.vertex(x2, y2, u2, v2);
        this.vertex(x2, y1, u2, v1);
        this.endShape();
        this.stroke = savedStroke;
        this.textureMode = savedTextureMode;
    }

    public void shapeMode(int mode) {
        this.shapeMode = mode;
    }

    public void shape(PShape shape) {
        if (shape.isVisible()) {
            this.flush();
            if (this.shapeMode == 3) {
                this.pushMatrix();
                this.translate(-shape.getWidth() / 2.0f, -shape.getHeight() / 2.0f);
            }
            shape.draw(this);
            if (this.shapeMode == 3) {
                this.popMatrix();
            }
        }
    }

    public void shape(PShape shape, float x, float y) {
        if (shape.isVisible()) {
            this.flush();
            this.pushMatrix();
            if (this.shapeMode == 3) {
                this.translate(x - shape.getWidth() / 2.0f, y - shape.getHeight() / 2.0f);
            } else if (this.shapeMode == 0 || this.shapeMode == 1) {
                this.translate(x, y);
            }
            shape.draw(this);
            this.popMatrix();
        }
    }

    protected void shape(PShape shape, float x, float y, float z) {
        PGraphics.showMissingWarning("shape");
    }

    public void shape(PShape shape, float a, float b, float c, float d) {
        if (shape.isVisible()) {
            this.flush();
            this.pushMatrix();
            if (this.shapeMode == 3) {
                this.translate(a - c / 2.0f, b - d / 2.0f);
                this.scale(c / shape.getWidth(), d / shape.getHeight());
            } else if (this.shapeMode == 0) {
                this.translate(a, b);
                this.scale(c / shape.getWidth(), d / shape.getHeight());
            } else if (this.shapeMode == 1) {
                this.translate(a, b);
                this.scale((c -= a) / shape.getWidth(), (d -= b) / shape.getHeight());
            }
            shape.draw(this);
            this.popMatrix();
        }
    }

    protected void shape(PShape shape, float x, float y, float z, float c, float d, float e) {
        PGraphics.showMissingWarning("shape");
    }

    public void textAlign(int alignX) {
        this.textAlign(alignX, 0);
    }

    public void textAlign(int alignX, int alignY) {
        this.textAlign = alignX;
        this.textAlignY = alignY;
    }

    public float textAscent() {
        if (this.textFont == null) {
            this.defaultFontOrDeath("textAscent");
        }
        return this.textFont.ascent() * this.textSize;
    }

    public float textDescent() {
        if (this.textFont == null) {
            this.defaultFontOrDeath("textDescent");
        }
        return this.textFont.descent() * this.textSize;
    }

    public void textFont(PFont which) {
        if (which == null) {
            throw new RuntimeException("A null PFont was passed to textFont()");
        }
        this.textFont = which;
        this.textSize(which.size);
    }

    public void textFont(PFont which, float size) {
        this.textFont(which);
        this.textSize(size);
    }

    public void textLeading(float leading) {
        this.textLeading = leading;
    }

    public void textMode(int mode) {
        if (mode == 37 || mode == 39) {
            PGraphics.showWarning("Since Processing 1.0 beta, textMode() is now textAlign().");
            return;
        }
        if (mode == 256) {
            PGraphics.showWarning("textMode(SCREEN) has been removed from Processing 2.0.");
            return;
        }
        if (this.textModeCheck(mode)) {
            this.textMode = mode;
        } else {
            String modeStr = String.valueOf(mode);
            switch (mode) {
                case 4: {
                    modeStr = "MODEL";
                    break;
                }
                case 5: {
                    modeStr = "SHAPE";
                }
            }
            PGraphics.showWarning("textMode(" + modeStr + ") is not supported by this renderer.");
        }
    }

    protected boolean textModeCheck(int mode) {
        return true;
    }

    public void textSize(float size) {
        if (this.textFont == null) {
            this.defaultFontOrDeath("textSize", size);
        }
        this.textSize = size;
        this.textLeading = (this.textAscent() + this.textDescent()) * 1.275f;
    }

    public float textWidth(char c) {
        this.textWidthBuffer[0] = c;
        return this.textWidthImpl(this.textWidthBuffer, 0, 1);
    }

    public float textWidth(String str) {
        int index;
        int length;
        if (this.textFont == null) {
            this.defaultFontOrDeath("textWidth");
        }
        if ((length = str.length()) > this.textWidthBuffer.length) {
            this.textWidthBuffer = new char[length + 10];
        }
        str.getChars(0, length, this.textWidthBuffer, 0);
        float wide = 0.0f;
        int start = 0;
        for (index = 0; index < length; ++index) {
            if (this.textWidthBuffer[index] != '\n') continue;
            wide = Math.max(wide, this.textWidthImpl(this.textWidthBuffer, start, index));
            start = index + 1;
        }
        if (start < length) {
            wide = Math.max(wide, this.textWidthImpl(this.textWidthBuffer, start, index));
        }
        return wide;
    }

    public float textWidth(char[] chars, int start, int length) {
        return this.textWidthImpl(chars, start, start + length);
    }

    protected float textWidthImpl(char[] buffer, int start, int stop) {
        float wide = 0.0f;
        for (int i = start; i < stop; ++i) {
            wide += this.textFont.width(buffer[i]) * this.textSize;
        }
        return wide;
    }

    public void text(char c, float x, float y) {
        if (this.textFont == null) {
            this.defaultFontOrDeath("text");
        }
        if (this.textAlignY == 3) {
            y += this.textAscent() / 2.0f;
        } else if (this.textAlignY == 101) {
            y += this.textAscent();
        } else if (this.textAlignY == 102) {
            y -= this.textDescent();
        }
        this.textBuffer[0] = c;
        this.textLineAlignImpl(this.textBuffer, 0, 1, x, y);
    }

    public void text(char c, float x, float y, float z) {
        if (z != 0.0f) {
            this.translate(0.0f, 0.0f, z);
        }
        this.text(c, x, y);
        if (z != 0.0f) {
            this.translate(0.0f, 0.0f, -z);
        }
    }

    public void text(String str, float x, float y) {
        int length;
        if (this.textFont == null) {
            this.defaultFontOrDeath("text");
        }
        if ((length = str.length()) > this.textBuffer.length) {
            this.textBuffer = new char[length + 10];
        }
        str.getChars(0, length, this.textBuffer, 0);
        this.text(this.textBuffer, 0, length, x, y);
    }

    public void text(char[] chars, int start, int stop, float x, float y) {
        int index;
        float high = 0.0f;
        for (int i = start; i < stop; ++i) {
            if (chars[i] != '\n') continue;
            high += this.textLeading;
        }
        if (this.textAlignY == 3) {
            y += (this.textAscent() - high) / 2.0f;
        } else if (this.textAlignY == 101) {
            y += this.textAscent();
        } else if (this.textAlignY == 102) {
            y -= this.textDescent() + high;
        }
        for (index = 0; index < stop; ++index) {
            if (chars[index] != '\n') continue;
            this.textLineAlignImpl(chars, start, index, x, y);
            start = index + 1;
            y += this.textLeading;
        }
        if (start < stop) {
            this.textLineAlignImpl(chars, start, index, x, y);
        }
    }

    public void text(String str, float x, float y, float z) {
        if (z != 0.0f) {
            this.translate(0.0f, 0.0f, z);
        }
        this.text(str, x, y);
        if (z != 0.0f) {
            this.translate(0.0f, 0.0f, -z);
        }
    }

    public void text(char[] chars, int start, int stop, float x, float y, float z) {
        if (z != 0.0f) {
            this.translate(0.0f, 0.0f, z);
        }
        this.text(chars, start, stop, x, y);
        if (z != 0.0f) {
            this.translate(0.0f, 0.0f, -z);
        }
    }

    public void text(String str, float x1, float y1, float x2, float y2) {
        float temp;
        if (this.textFont == null) {
            this.defaultFontOrDeath("text");
        }
        switch (this.rectMode) {
            case 0: {
                x2 += x1;
                y2 += y1;
                break;
            }
            case 2: {
                float hradius = x2;
                float vradius = y2;
                x2 = x1 + hradius;
                y2 = y1 + vradius;
                x1 -= hradius;
                y1 -= vradius;
                break;
            }
            case 3: {
                float hradius = x2 / 2.0f;
                float vradius = y2 / 2.0f;
                x2 = x1 + hradius;
                y2 = y1 + vradius;
                x1 -= hradius;
                y1 -= vradius;
            }
        }
        if (x2 < x1) {
            temp = x1;
            x1 = x2;
            x2 = temp;
        }
        if (y2 < y1) {
            temp = y1;
            y1 = y2;
            y2 = temp;
        }
        float boxWidth = x2 - x1;
        float spaceWidth = this.textWidth(' ');
        if (this.textBreakStart == null) {
            this.textBreakStart = new int[20];
            this.textBreakStop = new int[20];
        }
        this.textBreakCount = 0;
        int length = str.length();
        if (length + 1 > this.textBuffer.length) {
            this.textBuffer = new char[length + 1];
        }
        str.getChars(0, length, this.textBuffer, 0);
        this.textBuffer[length++] = 10;
        int sentenceStart = 0;
        for (int i = 0; i < length; ++i) {
            if (this.textBuffer[i] != '\n') continue;
            boolean legit = this.textSentence(this.textBuffer, sentenceStart, i, boxWidth, spaceWidth);
            if (!legit) break;
            sentenceStart = i + 1;
        }
        float lineX = x1;
        if (this.textAlign == 3) {
            lineX += boxWidth / 2.0f;
        } else if (this.textAlign == 39) {
            lineX = x2;
        }
        float boxHeight = y2 - y1;
        float topAndBottom = this.textAscent() + this.textDescent();
        int lineFitCount = 1 + PApplet.floor((boxHeight - topAndBottom) / this.textLeading);
        int lineCount = Math.min(this.textBreakCount, lineFitCount);
        if (this.textAlignY == 3) {
            float lineHigh = this.textAscent() + this.textLeading * (float)(lineCount - 1);
            float y = y1 + this.textAscent() + (boxHeight - lineHigh) / 2.0f;
            for (int i = 0; i < lineCount; ++i) {
                this.textLineAlignImpl(this.textBuffer, this.textBreakStart[i], this.textBreakStop[i], lineX, y);
                y += this.textLeading;
            }
        } else if (this.textAlignY == 102) {
            float y = y2 - this.textDescent() - this.textLeading * (float)(lineCount - 1);
            for (int i = 0; i < lineCount; ++i) {
                this.textLineAlignImpl(this.textBuffer, this.textBreakStart[i], this.textBreakStop[i], lineX, y);
                y += this.textLeading;
            }
        } else {
            float y = y1 + this.textAscent();
            for (int i = 0; i < lineCount; ++i) {
                this.textLineAlignImpl(this.textBuffer, this.textBreakStart[i], this.textBreakStop[i], lineX, y);
                y += this.textLeading;
            }
        }
    }

    protected boolean textSentence(char[] buffer, int start, int stop, float boxWidth, float spaceWidth) {
        float runningX = 0.0f;
        int lineStart = start;
        int wordStart = start;
        int index = start;
        while (index <= stop) {
            if (buffer[index] == ' ' || index == stop) {
                float wordWidth = this.textWidthImpl(buffer, wordStart, index);
                if (runningX + wordWidth > boxWidth) {
                    if (runningX != 0.0f) {
                        this.textSentenceBreak(lineStart, index);
                        for (index = wordStart; index < stop && buffer[index] == ' '; ++index) {
                        }
                    } else {
                        do {
                            if (--index != wordStart) continue;
                            return false;
                        } while ((wordWidth = this.textWidthImpl(buffer, wordStart, index)) > boxWidth);
                        this.textSentenceBreak(lineStart, index);
                    }
                    lineStart = index;
                    wordStart = index;
                    runningX = 0.0f;
                    continue;
                }
                if (index == stop) {
                    this.textSentenceBreak(lineStart, index);
                    ++index;
                    continue;
                }
                runningX += wordWidth + spaceWidth;
                wordStart = index + 1;
                ++index;
                continue;
            }
            ++index;
        }
        return true;
    }

    protected void textSentenceBreak(int start, int stop) {
        if (this.textBreakCount == this.textBreakStart.length) {
            this.textBreakStart = PApplet.expand(this.textBreakStart);
            this.textBreakStop = PApplet.expand(this.textBreakStop);
        }
        this.textBreakStart[this.textBreakCount] = start;
        this.textBreakStop[this.textBreakCount] = stop;
        ++this.textBreakCount;
    }

    public void text(int num, float x, float y) {
        this.text(String.valueOf(num), x, y);
    }

    public void text(int num, float x, float y, float z) {
        this.text(String.valueOf(num), x, y, z);
    }

    public void text(float num, float x, float y) {
        this.text(PApplet.nfs(num, 0, 3), x, y);
    }

    public void text(float num, float x, float y, float z) {
        this.text(PApplet.nfs(num, 0, 3), x, y, z);
    }

    protected void textLineAlignImpl(char[] buffer, int start, int stop, float x, float y) {
        if (this.textAlign == 3) {
            x -= this.textWidthImpl(buffer, start, stop) / 2.0f;
        } else if (this.textAlign == 39) {
            x -= this.textWidthImpl(buffer, start, stop);
        }
        this.textLineImpl(buffer, start, stop, x, y);
    }

    protected void textLineImpl(char[] buffer, int start, int stop, float x, float y) {
        for (int index = start; index < stop; ++index) {
            this.textCharImpl(buffer[index], x, y);
            x += this.textWidth(buffer[index]);
        }
    }

    protected void textCharImpl(char ch, float x, float y) {
        PFont.Glyph glyph = this.textFont.getGlyph(ch);
        if (glyph != null) {
            if (this.textMode == 4) {
                float high = (float)glyph.height / (float)this.textFont.size;
                float bwidth = (float)glyph.width / (float)this.textFont.size;
                float lextent = (float)glyph.leftExtent / (float)this.textFont.size;
                float textent = (float)glyph.topExtent / (float)this.textFont.size;
                float x1 = x + lextent * this.textSize;
                float y1 = y - textent * this.textSize;
                float x2 = x1 + bwidth * this.textSize;
                float y2 = y1 + high * this.textSize;
                this.textCharModelImpl(glyph.image, x1, y1, x2, y2, glyph.width, glyph.height);
            }
        } else if (ch != ' ' && ch != '\u007f') {
            PGraphics.showWarning("No glyph found for the " + ch + " (\\u" + PApplet.hex(ch, 4) + ") character");
        }
    }

    protected void textCharModelImpl(PImage glyph, float x1, float y1, float x2, float y2, int u2, int v2) {
        boolean savedTint = this.tint;
        int savedTintColor = this.tintColor;
        float savedTintR = this.tintR;
        float savedTintG = this.tintG;
        float savedTintB = this.tintB;
        float savedTintA = this.tintA;
        boolean savedTintAlpha = this.tintAlpha;
        this.tint = true;
        this.tintColor = this.fillColor;
        this.tintR = this.fillR;
        this.tintG = this.fillG;
        this.tintB = this.fillB;
        this.tintA = this.fillA;
        this.tintAlpha = this.fillAlpha;
        this.imageImpl(glyph, x1, y1, x2, y2, 0, 0, u2, v2);
        this.tint = savedTint;
        this.tintColor = savedTintColor;
        this.tintR = savedTintR;
        this.tintG = savedTintG;
        this.tintB = savedTintB;
        this.tintA = savedTintA;
        this.tintAlpha = savedTintAlpha;
    }

    protected void textCharScreenImpl(PImage glyph, int xx, int yy, int w0, int h0) {
        int x0 = 0;
        int y0 = 0;
        if (xx >= this.width || yy >= this.height || xx + w0 < 0 || yy + h0 < 0) {
            return;
        }
        if (xx < 0) {
            x0 -= xx;
            w0 += xx;
            xx = 0;
        }
        if (yy < 0) {
            y0 -= yy;
            h0 += yy;
            yy = 0;
        }
        if (xx + w0 > this.width) {
            w0 -= xx + w0 - this.width;
        }
        if (yy + h0 > this.height) {
            h0 -= yy + h0 - this.height;
        }
        int fr = this.fillRi;
        int fg = this.fillGi;
        int fb = this.fillBi;
        int fa = this.fillAi;
        int[] pixels1 = glyph.pixels;
        for (int row = y0; row < y0 + h0; ++row) {
            for (int col = x0; col < x0 + w0; ++col) {
                int a1 = fa * pixels1[row * glyph.width + col] >> 8;
                int a2 = a1 ^ 0xFF;
                int p2 = this.pixels[(yy + row - y0) * this.width + (xx + col - x0)];
                this.pixels[(yy + row - y0) * this.width + xx + col - x0] = 0xFF000000 | (a1 * fr + a2 * (p2 >> 16 & 0xFF) & 0xFF00) << 8 | a1 * fg + a2 * (p2 >> 8 & 0xFF) & 0xFF00 | a1 * fb + a2 * (p2 & 0xFF) >> 8;
            }
        }
    }

    public void pushMatrix() {
        PGraphics.showMethodWarning("pushMatrix");
    }

    public void popMatrix() {
        PGraphics.showMethodWarning("popMatrix");
    }

    public void translate(float x, float y) {
        PGraphics.showMissingWarning("translate");
    }

    public void translate(float x, float y, float z) {
        PGraphics.showMissingWarning("translate");
    }

    public void rotate(float angle) {
        PGraphics.showMissingWarning("rotate");
    }

    public void rotateX(float angle) {
        PGraphics.showMethodWarning("rotateX");
    }

    public void rotateY(float angle) {
        PGraphics.showMethodWarning("rotateY");
    }

    public void rotateZ(float angle) {
        PGraphics.showMethodWarning("rotateZ");
    }

    public void rotate(float angle, float x, float y, float z) {
        PGraphics.showMissingWarning("rotate");
    }

    public void scale(float s) {
        PGraphics.showMissingWarning("scale");
    }

    public void scale(float x, float y) {
        PGraphics.showMissingWarning("scale");
    }

    public void scale(float x, float y, float z) {
        PGraphics.showMissingWarning("scale");
    }

    public void shearX(float angle) {
        PGraphics.showMissingWarning("shearX");
    }

    public void shearY(float angle) {
        PGraphics.showMissingWarning("shearY");
    }

    public void resetMatrix() {
        PGraphics.showMethodWarning("resetMatrix");
    }

    public void applyMatrix(PMatrix source) {
        if (source instanceof PMatrix2D) {
            this.applyMatrix((PMatrix2D)source);
        } else if (source instanceof PMatrix3D) {
            this.applyMatrix((PMatrix3D)source);
        }
    }

    public void applyMatrix(PMatrix2D source) {
        this.applyMatrix(source.m00, source.m01, source.m02, source.m10, source.m11, source.m12);
    }

    public void applyMatrix(float n00, float n01, float n02, float n10, float n11, float n12) {
        PGraphics.showMissingWarning("applyMatrix");
    }

    public void applyMatrix(PMatrix3D source) {
        this.applyMatrix(source.m00, source.m01, source.m02, source.m03, source.m10, source.m11, source.m12, source.m13, source.m20, source.m21, source.m22, source.m23, source.m30, source.m31, source.m32, source.m33);
    }

    public void applyMatrix(float n00, float n01, float n02, float n03, float n10, float n11, float n12, float n13, float n20, float n21, float n22, float n23, float n30, float n31, float n32, float n33) {
        PGraphics.showMissingWarning("applyMatrix");
    }

    public PMatrix getMatrix() {
        PGraphics.showMissingWarning("getMatrix");
        return null;
    }

    public PMatrix2D getMatrix(PMatrix2D target) {
        PGraphics.showMissingWarning("getMatrix");
        return null;
    }

    public PMatrix3D getMatrix(PMatrix3D target) {
        PGraphics.showMissingWarning("getMatrix");
        return null;
    }

    public void setMatrix(PMatrix source) {
        if (source instanceof PMatrix2D) {
            this.setMatrix((PMatrix2D)source);
        } else if (source instanceof PMatrix3D) {
            this.setMatrix((PMatrix3D)source);
        }
    }

    public void setMatrix(PMatrix2D source) {
        PGraphics.showMissingWarning("setMatrix");
    }

    public void setMatrix(PMatrix3D source) {
        PGraphics.showMissingWarning("setMatrix");
    }

    public void printMatrix() {
        PGraphics.showMethodWarning("printMatrix");
    }

    public void beginCamera() {
        PGraphics.showMethodWarning("beginCamera");
    }

    public void endCamera() {
        PGraphics.showMethodWarning("endCamera");
    }

    public void camera() {
        PGraphics.showMissingWarning("camera");
    }

    public void camera(float eyeX, float eyeY, float eyeZ, float centerX, float centerY, float centerZ, float upX, float upY, float upZ) {
        PGraphics.showMissingWarning("camera");
    }

    public void printCamera() {
        PGraphics.showMethodWarning("printCamera");
    }

    public void ortho() {
        PGraphics.showMissingWarning("ortho");
    }

    public void ortho(float left, float right, float bottom, float top) {
        PGraphics.showMissingWarning("ortho");
    }

    public void ortho(float left, float right, float bottom, float top, float near, float far) {
        PGraphics.showMissingWarning("ortho");
    }

    public void perspective() {
        PGraphics.showMissingWarning("perspective");
    }

    public void perspective(float fovy, float aspect, float zNear, float zFar) {
        PGraphics.showMissingWarning("perspective");
    }

    public void frustum(float left, float right, float bottom, float top, float near, float far) {
        PGraphics.showMethodWarning("frustum");
    }

    public void printProjection() {
        PGraphics.showMethodWarning("printProjection");
    }

    public float screenX(float x, float y) {
        PGraphics.showMissingWarning("screenX");
        return 0.0f;
    }

    public float screenY(float x, float y) {
        PGraphics.showMissingWarning("screenY");
        return 0.0f;
    }

    public float screenX(float x, float y, float z) {
        PGraphics.showMissingWarning("screenX");
        return 0.0f;
    }

    public float screenY(float x, float y, float z) {
        PGraphics.showMissingWarning("screenY");
        return 0.0f;
    }

    public float screenZ(float x, float y, float z) {
        PGraphics.showMissingWarning("screenZ");
        return 0.0f;
    }

    public float modelX(float x, float y, float z) {
        PGraphics.showMissingWarning("modelX");
        return 0.0f;
    }

    public float modelY(float x, float y, float z) {
        PGraphics.showMissingWarning("modelY");
        return 0.0f;
    }

    public float modelZ(float x, float y, float z) {
        PGraphics.showMissingWarning("modelZ");
        return 0.0f;
    }

    public void pushStyle() {
        if (this.styleStackDepth == this.styleStack.length) {
            this.styleStack = (PStyle[])PApplet.expand(this.styleStack);
        }
        if (this.styleStack[this.styleStackDepth] == null) {
            this.styleStack[this.styleStackDepth] = new PStyle();
        }
        PStyle s = this.styleStack[this.styleStackDepth++];
        this.getStyle(s);
    }

    public void popStyle() {
        if (this.styleStackDepth == 0) {
            throw new RuntimeException("Too many popStyle() without enough pushStyle()");
        }
        --this.styleStackDepth;
        this.style(this.styleStack[this.styleStackDepth]);
    }

    public void style(PStyle s) {
        this.imageMode(s.imageMode);
        this.rectMode(s.rectMode);
        this.ellipseMode(s.ellipseMode);
        this.shapeMode(s.shapeMode);
        if (s.tint) {
            this.tint(s.tintColor);
        } else {
            this.noTint();
        }
        if (s.fill) {
            this.fill(s.fillColor);
        } else {
            this.noFill();
        }
        if (s.stroke) {
            this.stroke(s.strokeColor);
        } else {
            this.noStroke();
        }
        this.strokeWeight(s.strokeWeight);
        this.strokeCap(s.strokeCap);
        this.strokeJoin(s.strokeJoin);
        this.colorMode(1, 1.0f);
        this.ambient(s.ambientR, s.ambientG, s.ambientB);
        this.emissive(s.emissiveR, s.emissiveG, s.emissiveB);
        this.specular(s.specularR, s.specularG, s.specularB);
        this.shininess(s.shininess);
        this.colorMode(s.colorMode, s.colorModeX, s.colorModeY, s.colorModeZ, s.colorModeA);
        if (s.textFont != null) {
            this.textFont(s.textFont, s.textSize);
            this.textLeading(s.textLeading);
        }
        this.textAlign(s.textAlign, s.textAlignY);
        this.textMode(s.textMode);
    }

    public PStyle getStyle() {
        return this.getStyle(null);
    }

    public PStyle getStyle(PStyle s) {
        if (s == null) {
            s = new PStyle();
        }
        s.imageMode = this.imageMode;
        s.rectMode = this.rectMode;
        s.ellipseMode = this.ellipseMode;
        s.shapeMode = this.shapeMode;
        s.colorMode = this.colorMode;
        s.colorModeX = this.colorModeX;
        s.colorModeY = this.colorModeY;
        s.colorModeZ = this.colorModeZ;
        s.colorModeA = this.colorModeA;
        s.tint = this.tint;
        s.tintColor = this.tintColor;
        s.fill = this.fill;
        s.fillColor = this.fillColor;
        s.stroke = this.stroke;
        s.strokeColor = this.strokeColor;
        s.strokeWeight = this.strokeWeight;
        s.strokeCap = this.strokeCap;
        s.strokeJoin = this.strokeJoin;
        s.ambientR = this.ambientR;
        s.ambientG = this.ambientG;
        s.ambientB = this.ambientB;
        s.specularR = this.specularR;
        s.specularG = this.specularG;
        s.specularB = this.specularB;
        s.emissiveR = this.emissiveR;
        s.emissiveG = this.emissiveG;
        s.emissiveB = this.emissiveB;
        s.shininess = this.shininess;
        s.textFont = this.textFont;
        s.textAlign = this.textAlign;
        s.textAlignY = this.textAlignY;
        s.textMode = this.textMode;
        s.textSize = this.textSize;
        s.textLeading = this.textLeading;
        return s;
    }

    public void strokeWeight(float weight) {
        this.strokeWeight = weight;
    }

    public void strokeJoin(int join) {
        this.strokeJoin = join;
    }

    public void strokeCap(int cap) {
        this.strokeCap = cap;
    }

    public void noStroke() {
        this.stroke = false;
    }

    public void stroke(int rgb) {
        this.colorCalc(rgb);
        this.strokeFromCalc();
    }

    public void stroke(int rgb, float alpha) {
        this.colorCalc(rgb, alpha);
        this.strokeFromCalc();
    }

    public void stroke(float gray) {
        this.colorCalc(gray);
        this.strokeFromCalc();
    }

    public void stroke(float gray, float alpha) {
        this.colorCalc(gray, alpha);
        this.strokeFromCalc();
    }

    public void stroke(float v1, float v2, float v3) {
        this.colorCalc(v1, v2, v3);
        this.strokeFromCalc();
    }

    public void stroke(float v1, float v2, float v3, float alpha) {
        this.colorCalc(v1, v2, v3, alpha);
        this.strokeFromCalc();
    }

    protected void strokeFromCalc() {
        this.stroke = true;
        this.strokeR = this.calcR;
        this.strokeG = this.calcG;
        this.strokeB = this.calcB;
        this.strokeA = this.calcA;
        this.strokeRi = this.calcRi;
        this.strokeGi = this.calcGi;
        this.strokeBi = this.calcBi;
        this.strokeAi = this.calcAi;
        this.strokeColor = this.calcColor;
        this.strokeAlpha = this.calcAlpha;
    }

    public void noTint() {
        this.tint = false;
    }

    public void tint(int rgb) {
        this.colorCalc(rgb);
        this.tintFromCalc();
    }

    public void tint(int rgb, float alpha) {
        this.colorCalc(rgb, alpha);
        this.tintFromCalc();
    }

    public void tint(float gray) {
        this.colorCalc(gray);
        this.tintFromCalc();
    }

    public void tint(float gray, float alpha) {
        this.colorCalc(gray, alpha);
        this.tintFromCalc();
    }

    public void tint(float v1, float v2, float v3) {
        this.colorCalc(v1, v2, v3);
        this.tintFromCalc();
    }

    public void tint(float v1, float v2, float v3, float alpha) {
        this.colorCalc(v1, v2, v3, alpha);
        this.tintFromCalc();
    }

    protected void tintFromCalc() {
        this.tint = true;
        this.tintR = this.calcR;
        this.tintG = this.calcG;
        this.tintB = this.calcB;
        this.tintA = this.calcA;
        this.tintRi = this.calcRi;
        this.tintGi = this.calcGi;
        this.tintBi = this.calcBi;
        this.tintAi = this.calcAi;
        this.tintColor = this.calcColor;
        this.tintAlpha = this.calcAlpha;
    }

    public void noFill() {
        this.fill = false;
    }

    public void fill(int rgb) {
        this.colorCalc(rgb);
        this.fillFromCalc();
    }

    public void fill(int rgb, float alpha) {
        this.colorCalc(rgb, alpha);
        this.fillFromCalc();
    }

    public void fill(float gray) {
        this.colorCalc(gray);
        this.fillFromCalc();
    }

    public void fill(float gray, float alpha) {
        this.colorCalc(gray, alpha);
        this.fillFromCalc();
    }

    public void fill(float v1, float v2, float v3) {
        this.colorCalc(v1, v2, v3);
        this.fillFromCalc();
    }

    public void fill(float v1, float v2, float v3, float alpha) {
        this.colorCalc(v1, v2, v3, alpha);
        this.fillFromCalc();
    }

    protected void fillFromCalc() {
        this.fill = true;
        this.fillR = this.calcR;
        this.fillG = this.calcG;
        this.fillB = this.calcB;
        this.fillA = this.calcA;
        this.fillRi = this.calcRi;
        this.fillGi = this.calcGi;
        this.fillBi = this.calcBi;
        this.fillAi = this.calcAi;
        this.fillColor = this.calcColor;
        this.fillAlpha = this.calcAlpha;
    }

    public void ambient(int rgb) {
        this.colorCalc(rgb);
        this.ambientFromCalc();
    }

    public void ambient(float gray) {
        this.colorCalc(gray);
        this.ambientFromCalc();
    }

    public void ambient(float v1, float v2, float v3) {
        this.colorCalc(v1, v2, v3);
        this.ambientFromCalc();
    }

    protected void ambientFromCalc() {
        this.ambientColor = this.calcColor;
        this.ambientR = this.calcR;
        this.ambientG = this.calcG;
        this.ambientB = this.calcB;
        this.setAmbient = true;
    }

    public void specular(int rgb) {
        this.colorCalc(rgb);
        this.specularFromCalc();
    }

    public void specular(float gray) {
        this.colorCalc(gray);
        this.specularFromCalc();
    }

    public void specular(float v1, float v2, float v3) {
        this.colorCalc(v1, v2, v3);
        this.specularFromCalc();
    }

    protected void specularFromCalc() {
        this.specularColor = this.calcColor;
        this.specularR = this.calcR;
        this.specularG = this.calcG;
        this.specularB = this.calcB;
    }

    public void shininess(float shine) {
        this.shininess = shine;
    }

    public void emissive(int rgb) {
        this.colorCalc(rgb);
        this.emissiveFromCalc();
    }

    public void emissive(float gray) {
        this.colorCalc(gray);
        this.emissiveFromCalc();
    }

    public void emissive(float v1, float v2, float v3) {
        this.colorCalc(v1, v2, v3);
        this.emissiveFromCalc();
    }

    protected void emissiveFromCalc() {
        this.emissiveColor = this.calcColor;
        this.emissiveR = this.calcR;
        this.emissiveG = this.calcG;
        this.emissiveB = this.calcB;
    }

    public void lights() {
        PGraphics.showMethodWarning("lights");
    }

    public void noLights() {
        PGraphics.showMethodWarning("noLights");
    }

    public void ambientLight(float v1, float v2, float v3) {
        PGraphics.showMethodWarning("ambientLight");
    }

    public void ambientLight(float v1, float v2, float v3, float x, float y, float z) {
        PGraphics.showMethodWarning("ambientLight");
    }

    public void directionalLight(float v1, float v2, float v3, float nx, float ny, float nz) {
        PGraphics.showMethodWarning("directionalLight");
    }

    public void pointLight(float v1, float v2, float v3, float x, float y, float z) {
        PGraphics.showMethodWarning("pointLight");
    }

    public void spotLight(float v1, float v2, float v3, float x, float y, float z, float nx, float ny, float nz, float angle, float concentration) {
        PGraphics.showMethodWarning("spotLight");
    }

    public void lightFalloff(float constant, float linear, float quadratic) {
        PGraphics.showMethodWarning("lightFalloff");
    }

    public void lightSpecular(float v1, float v2, float v3) {
        PGraphics.showMethodWarning("lightSpecular");
    }

    public void background(int rgb) {
        this.colorCalc(rgb);
        this.backgroundFromCalc();
    }

    public void background(int rgb, float alpha) {
        this.colorCalc(rgb, alpha);
        this.backgroundFromCalc();
    }

    public void background(float gray) {
        this.colorCalc(gray);
        this.backgroundFromCalc();
    }

    public void background(float gray, float alpha) {
        if (this.format == 1) {
            this.background(gray);
        } else {
            this.colorCalc(gray, alpha);
            this.backgroundFromCalc();
        }
    }

    public void background(float v1, float v2, float v3) {
        this.colorCalc(v1, v2, v3);
        this.backgroundFromCalc();
    }

    public void background(float v1, float v2, float v3, float alpha) {
        this.colorCalc(v1, v2, v3, alpha);
        this.backgroundFromCalc();
    }

    public void clear() {
        this.background(0.0f, 0.0f, 0.0f, 0.0f);
    }

    protected void backgroundFromCalc() {
        this.backgroundR = this.calcR;
        this.backgroundG = this.calcG;
        this.backgroundB = this.calcB;
        this.backgroundA = this.format == 1 ? this.colorModeA : this.calcA;
        this.backgroundRi = this.calcRi;
        this.backgroundGi = this.calcGi;
        this.backgroundBi = this.calcBi;
        this.backgroundAi = this.format == 1 ? 255 : this.calcAi;
        this.backgroundAlpha = this.format == 1 ? false : this.calcAlpha;
        this.backgroundColor = this.calcColor;
        this.backgroundImpl();
    }

    public void background(PImage image) {
        if (image.width != this.width || image.height != this.height) {
            throw new RuntimeException("background image must be the same size as your application");
        }
        if (image.format != 1 && image.format != 2) {
            throw new RuntimeException("background images should be RGB or ARGB");
        }
        this.backgroundColor = 0;
        this.backgroundImpl(image);
    }

    protected void backgroundImpl(PImage image) {
        this.set(0, 0, image);
    }

    protected void backgroundImpl() {
        this.pushStyle();
        this.pushMatrix();
        this.resetMatrix();
        this.fill(this.backgroundColor);
        this.rect(0.0f, 0.0f, this.width, this.height);
        this.popMatrix();
        this.popStyle();
    }

    public void colorMode(int mode) {
        this.colorMode(mode, this.colorModeX, this.colorModeY, this.colorModeZ, this.colorModeA);
    }

    public void colorMode(int mode, float max) {
        this.colorMode(mode, max, max, max, max);
    }

    public void colorMode(int mode, float max1, float max2, float max3) {
        this.colorMode(mode, max1, max2, max3, this.colorModeA);
    }

    public void colorMode(int mode, float max1, float max2, float max3, float maxA) {
        this.colorMode = mode;
        this.colorModeX = max1;
        this.colorModeY = max2;
        this.colorModeZ = max3;
        this.colorModeA = maxA;
        this.colorModeScale = maxA != 1.0f || max1 != max2 || max2 != max3 || max3 != maxA;
        this.colorModeDefault = this.colorMode == 1 && this.colorModeA == 255.0f && this.colorModeX == 255.0f && this.colorModeY == 255.0f && this.colorModeZ == 255.0f;
    }

    protected void colorCalc(int rgb) {
        if ((rgb & 0xFF000000) == 0 && (float)rgb <= this.colorModeX) {
            this.colorCalc((float)rgb);
        } else {
            this.colorCalcARGB(rgb, this.colorModeA);
        }
    }

    protected void colorCalc(int rgb, float alpha) {
        if ((rgb & 0xFF000000) == 0 && (float)rgb <= this.colorModeX) {
            this.colorCalc((float)rgb, alpha);
        } else {
            this.colorCalcARGB(rgb, alpha);
        }
    }

    protected void colorCalc(float gray) {
        this.colorCalc(gray, this.colorModeA);
    }

    protected void colorCalc(float gray, float alpha) {
        if (gray > this.colorModeX) {
            gray = this.colorModeX;
        }
        if (alpha > this.colorModeA) {
            alpha = this.colorModeA;
        }
        if (gray < 0.0f) {
            gray = 0.0f;
        }
        if (alpha < 0.0f) {
            alpha = 0.0f;
        }
        this.calcG = this.calcR = this.colorModeScale ? gray / this.colorModeX : gray;
        this.calcB = this.calcR;
        this.calcA = this.colorModeScale ? alpha / this.colorModeA : alpha;
        this.calcRi = (int)(this.calcR * 255.0f);
        this.calcGi = (int)(this.calcG * 255.0f);
        this.calcBi = (int)(this.calcB * 255.0f);
        this.calcAi = (int)(this.calcA * 255.0f);
        this.calcColor = this.calcAi << 24 | this.calcRi << 16 | this.calcGi << 8 | this.calcBi;
        this.calcAlpha = this.calcAi != 255;
    }

    protected void colorCalc(float x, float y, float z) {
        this.colorCalc(x, y, z, this.colorModeA);
    }

    protected void colorCalc(float x, float y, float z, float a) {
        if (x > this.colorModeX) {
            x = this.colorModeX;
        }
        if (y > this.colorModeY) {
            y = this.colorModeY;
        }
        if (z > this.colorModeZ) {
            z = this.colorModeZ;
        }
        if (a > this.colorModeA) {
            a = this.colorModeA;
        }
        if (x < 0.0f) {
            x = 0.0f;
        }
        if (y < 0.0f) {
            y = 0.0f;
        }
        if (z < 0.0f) {
            z = 0.0f;
        }
        if (a < 0.0f) {
            a = 0.0f;
        }
        block0 : switch (this.colorMode) {
            case 1: {
                if (this.colorModeScale) {
                    this.calcR = x / this.colorModeX;
                    this.calcG = y / this.colorModeY;
                    this.calcB = z / this.colorModeZ;
                    this.calcA = a / this.colorModeA;
                    break;
                }
                this.calcR = x;
                this.calcG = y;
                this.calcB = z;
                this.calcA = a;
                break;
            }
            case 3: {
                x /= this.colorModeX;
                z /= this.colorModeZ;
                float f = this.calcA = this.colorModeScale ? a / this.colorModeA : a;
                if ((y /= this.colorModeY) == 0.0f) {
                    this.calcG = this.calcB = z;
                    this.calcR = this.calcB;
                    break;
                }
                float which = (x - (float)((int)x)) * 6.0f;
                float f2 = which - (float)((int)which);
                float p = z * (1.0f - y);
                float q = z * (1.0f - y * f2);
                float t = z * (1.0f - y * (1.0f - f2));
                switch ((int)which) {
                    case 0: {
                        this.calcR = z;
                        this.calcG = t;
                        this.calcB = p;
                        break block0;
                    }
                    case 1: {
                        this.calcR = q;
                        this.calcG = z;
                        this.calcB = p;
                        break block0;
                    }
                    case 2: {
                        this.calcR = p;
                        this.calcG = z;
                        this.calcB = t;
                        break block0;
                    }
                    case 3: {
                        this.calcR = p;
                        this.calcG = q;
                        this.calcB = z;
                        break block0;
                    }
                    case 4: {
                        this.calcR = t;
                        this.calcG = p;
                        this.calcB = z;
                        break block0;
                    }
                    case 5: {
                        this.calcR = z;
                        this.calcG = p;
                        this.calcB = q;
                    }
                }
            }
        }
        this.calcRi = (int)(255.0f * this.calcR);
        this.calcGi = (int)(255.0f * this.calcG);
        this.calcBi = (int)(255.0f * this.calcB);
        this.calcAi = (int)(255.0f * this.calcA);
        this.calcColor = this.calcAi << 24 | this.calcRi << 16 | this.calcGi << 8 | this.calcBi;
        this.calcAlpha = this.calcAi != 255;
    }

    protected void colorCalcARGB(int argb, float alpha) {
        if (alpha == this.colorModeA) {
            this.calcAi = argb >> 24 & 0xFF;
            this.calcColor = argb;
        } else {
            this.calcAi = (int)((float)(argb >> 24 & 0xFF) * (alpha / this.colorModeA));
            this.calcColor = this.calcAi << 24 | argb & 0xFFFFFF;
        }
        this.calcRi = argb >> 16 & 0xFF;
        this.calcGi = argb >> 8 & 0xFF;
        this.calcBi = argb & 0xFF;
        this.calcA = (float)this.calcAi / 255.0f;
        this.calcR = (float)this.calcRi / 255.0f;
        this.calcG = (float)this.calcGi / 255.0f;
        this.calcB = (float)this.calcBi / 255.0f;
        this.calcAlpha = this.calcAi != 255;
    }

    public final int color(int c) {
        this.colorCalc(c);
        return this.calcColor;
    }

    public final int color(float gray) {
        this.colorCalc(gray);
        return this.calcColor;
    }

    public final int color(int c, int alpha) {
        this.colorCalc(c, (float)alpha);
        return this.calcColor;
    }

    public final int color(int c, float alpha) {
        this.colorCalc(c, alpha);
        return this.calcColor;
    }

    public final int color(float gray, float alpha) {
        this.colorCalc(gray, alpha);
        return this.calcColor;
    }

    public final int color(int v1, int v2, int v3) {
        this.colorCalc(v1, v2, v3);
        return this.calcColor;
    }

    public final int color(float v1, float v2, float v3) {
        this.colorCalc(v1, v2, v3);
        return this.calcColor;
    }

    public final int color(int v1, int v2, int v3, int a) {
        this.colorCalc(v1, v2, v3, a);
        return this.calcColor;
    }

    public final int color(float v1, float v2, float v3, float a) {
        this.colorCalc(v1, v2, v3, a);
        return this.calcColor;
    }

    public final float alpha(int rgb) {
        float outgoing = rgb >> 24 & 0xFF;
        if (this.colorModeA == 255.0f) {
            return outgoing;
        }
        return outgoing / 255.0f * this.colorModeA;
    }

    public final float red(int rgb) {
        float c = rgb >> 16 & 0xFF;
        if (this.colorModeDefault) {
            return c;
        }
        return c / 255.0f * this.colorModeX;
    }

    public final float green(int rgb) {
        float c = rgb >> 8 & 0xFF;
        if (this.colorModeDefault) {
            return c;
        }
        return c / 255.0f * this.colorModeY;
    }

    public final float blue(int rgb) {
        float c = rgb & 0xFF;
        if (this.colorModeDefault) {
            return c;
        }
        return c / 255.0f * this.colorModeZ;
    }

    public final float hue(int rgb) {
        if (rgb != this.cacheHsbKey) {
            Color.RGBtoHSB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF, this.cacheHsbValue);
            this.cacheHsbKey = rgb;
        }
        return this.cacheHsbValue[0] * this.colorModeX;
    }

    public final float saturation(int rgb) {
        if (rgb != this.cacheHsbKey) {
            Color.RGBtoHSB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF, this.cacheHsbValue);
            this.cacheHsbKey = rgb;
        }
        return this.cacheHsbValue[1] * this.colorModeY;
    }

    public final float brightness(int rgb) {
        if (rgb != this.cacheHsbKey) {
            Color.RGBtoHSB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF, this.cacheHsbValue);
            this.cacheHsbKey = rgb;
        }
        return this.cacheHsbValue[2] * this.colorModeZ;
    }

    public int lerpColor(int c1, int c2, float amt) {
        return PGraphics.lerpColor(c1, c2, amt, this.colorMode);
    }

    public static int lerpColor(int c1, int c2, float amt, int mode) {
        if (mode == 1) {
            float a1 = c1 >> 24 & 0xFF;
            float r1 = c1 >> 16 & 0xFF;
            float g1 = c1 >> 8 & 0xFF;
            float b1 = c1 & 0xFF;
            float a2 = c2 >> 24 & 0xFF;
            float r2 = c2 >> 16 & 0xFF;
            float g2 = c2 >> 8 & 0xFF;
            float b2 = c2 & 0xFF;
            return (int)(a1 + (a2 - a1) * amt) << 24 | (int)(r1 + (r2 - r1) * amt) << 16 | (int)(g1 + (g2 - g1) * amt) << 8 | (int)(b1 + (b2 - b1) * amt);
        }
        if (mode == 3) {
            if (lerpColorHSB1 == null) {
                lerpColorHSB1 = new float[3];
                lerpColorHSB2 = new float[3];
            }
            float a1 = c1 >> 24 & 0xFF;
            float a2 = c2 >> 24 & 0xFF;
            int alfa = (int)(a1 + (a2 - a1) * amt) << 24;
            Color.RGBtoHSB(c1 >> 16 & 0xFF, c1 >> 8 & 0xFF, c1 & 0xFF, lerpColorHSB1);
            Color.RGBtoHSB(c2 >> 16 & 0xFF, c2 >> 8 & 0xFF, c2 & 0xFF, lerpColorHSB2);
            float ho = PApplet.lerp(lerpColorHSB1[0], lerpColorHSB2[0], amt);
            float so = PApplet.lerp(lerpColorHSB1[1], lerpColorHSB2[1], amt);
            float bo = PApplet.lerp(lerpColorHSB1[2], lerpColorHSB2[2], amt);
            return alfa | Color.HSBtoRGB(ho, so, bo) & 0xFFFFFF;
        }
        return 0;
    }

    public void beginRaw(PGraphics rawGraphics) {
        this.raw = rawGraphics;
        rawGraphics.beginDraw();
    }

    public void endRaw() {
        if (this.raw != null) {
            this.flush();
            this.raw.endDraw();
            this.raw.dispose();
            this.raw = null;
        }
    }

    public boolean haveRaw() {
        return this.raw != null;
    }

    public PGraphics getRaw() {
        return this.raw;
    }

    public static void showWarning(String msg) {
        if (warnings == null) {
            warnings = new HashMap();
        }
        if (!warnings.containsKey(msg)) {
            System.err.println(msg);
            warnings.put(msg, new Object());
        }
    }

    public static void showWarning(String msg, Object ... args) {
        PGraphics.showWarning(String.format(msg, args));
    }

    public static void showDepthWarning(String method) {
        PGraphics.showWarning(method + "() can only be used with a renderer that " + "supports 3D, such as P3D or OPENGL.");
    }

    public static void showDepthWarningXYZ(String method) {
        PGraphics.showWarning(method + "() with x, y, and z coordinates " + "can only be used with a renderer that " + "supports 3D, such as P3D or OPENGL. " + "Use a version without a z-coordinate instead.");
    }

    public static void showMethodWarning(String method) {
        PGraphics.showWarning(method + "() is not available with this renderer.");
    }

    public static void showVariationWarning(String str) {
        PGraphics.showWarning(str + " is not available with this renderer.");
    }

    public static void showMissingWarning(String method) {
        PGraphics.showWarning(method + "(), or this particular variation of it, " + "is not available with this renderer.");
    }

    public static void showException(String msg) {
        throw new RuntimeException(msg);
    }

    protected void defaultFontOrDeath(String method) {
        this.defaultFontOrDeath(method, 12.0f);
    }

    protected void defaultFontOrDeath(String method, float size) {
        if (this.parent == null) {
            throw new RuntimeException("Use textFont() before " + method + "()");
        }
        this.textFont = this.parent.createDefaultFont(size);
    }

    public boolean displayable() {
        return true;
    }

    public boolean is2D() {
        return true;
    }

    public boolean is3D() {
        return false;
    }

    public boolean isGL() {
        return false;
    }

    static {
        for (int i = 0; i < 720; ++i) {
            PGraphics.sinLUT[i] = (float)Math.sin((float)i * ((float)Math.PI / 180) * 0.5f);
            PGraphics.cosLUT[i] = (float)Math.cos((float)i * ((float)Math.PI / 180) * 0.5f);
        }
    }
}

