/*
 * Decompiled with CFR 0.152.
 */
package processing.data;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Random;
import processing.core.PApplet;
import processing.data.IntList;
import processing.data.Sort;

public class FloatList
implements Iterable<Float> {
    int count;
    float[] data;

    public FloatList() {
        this.data = new float[10];
    }

    public FloatList(int length) {
        this.data = new float[length];
    }

    public FloatList(float[] list) {
        this.count = list.length;
        this.data = new float[this.count];
        System.arraycopy(list, 0, this.data, 0, this.count);
    }

    public FloatList(Iterable<Float> iter) {
        this(10);
        for (float v : iter) {
            this.append(v);
        }
    }

    private void crop() {
        if (this.count != this.data.length) {
            this.data = PApplet.subset(this.data, 0, this.count);
        }
    }

    public int size() {
        return this.count;
    }

    public void resize(int length) {
        if (length > this.data.length) {
            float[] temp = new float[length];
            System.arraycopy(this.data, 0, temp, 0, this.count);
            this.data = temp;
        } else if (length > this.count) {
            Arrays.fill(this.data, this.count, length, 0.0f);
        }
        this.count = length;
    }

    public void clear() {
        this.count = 0;
    }

    public float get(int index) {
        return this.data[index];
    }

    public void set(int index, float what) {
        if (index >= this.count) {
            this.data = PApplet.expand(this.data, index + 1);
            for (int i = this.count; i < index; ++i) {
                this.data[i] = 0.0f;
            }
            this.count = index + 1;
        }
        this.data[index] = what;
    }

    public float remove(int index) {
        if (index < 0 || index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        float entry = this.data[index];
        for (int i = index; i < this.count - 1; ++i) {
            this.data[i] = this.data[i + 1];
        }
        --this.count;
        return entry;
    }

    public int removeValue(int value) {
        int index = this.index(value);
        if (index != -1) {
            this.remove(index);
            return index;
        }
        return -1;
    }

    public int removeValues(int value) {
        int i;
        int ii = 0;
        if (Float.isNaN(value)) {
            for (i = 0; i < this.count; ++i) {
                if (Float.isNaN(this.data[i])) continue;
                this.data[ii++] = this.data[i];
            }
        } else {
            for (i = 0; i < this.count; ++i) {
                if (this.data[i] == (float)value) continue;
                this.data[ii++] = this.data[i];
            }
        }
        int removed = this.count - ii;
        this.count = ii;
        return removed;
    }

    public boolean replaceValue(float value, float newValue) {
        if (Float.isNaN(value)) {
            for (int i = 0; i < this.count; ++i) {
                if (!Float.isNaN(this.data[i])) continue;
                this.data[i] = newValue;
                return true;
            }
        } else {
            int index = this.index(value);
            if (index != -1) {
                this.data[index] = newValue;
                return true;
            }
        }
        return false;
    }

    public boolean replaceValues(float value, float newValue) {
        boolean changed = false;
        if (Float.isNaN(value)) {
            for (int i = 0; i < this.count; ++i) {
                if (!Float.isNaN(this.data[i])) continue;
                this.data[i] = newValue;
                changed = true;
            }
        } else {
            for (int i = 0; i < this.count; ++i) {
                if (this.data[i] != value) continue;
                this.data[i] = newValue;
                changed = true;
            }
        }
        return changed;
    }

    public void append(float value) {
        if (this.count == this.data.length) {
            this.data = PApplet.expand(this.data);
        }
        this.data[this.count++] = value;
    }

    public void append(float[] values) {
        for (float v : values) {
            this.append(v);
        }
    }

    public void append(FloatList list) {
        for (float v : list.values()) {
            this.append(v);
        }
    }

    public void insert(int index, int[] values) {
        if (index < 0) {
            throw new IllegalArgumentException("insert() index cannot be negative: it was " + index);
        }
        if (index >= values.length) {
            throw new IllegalArgumentException("insert() index " + index + " is past the end of this list");
        }
        float[] temp = new float[this.count + values.length];
        System.arraycopy(this.data, 0, temp, 0, Math.min(this.count, index));
        System.arraycopy(values, 0, temp, index, values.length);
        System.arraycopy(this.data, index, temp, index + values.length, this.count - index);
        this.count += values.length;
        this.data = temp;
    }

    public void insert(int index, IntList list) {
        this.insert(index, list.values());
    }

    public int index(float what) {
        for (int i = 0; i < this.count; ++i) {
            if (this.data[i] != what) continue;
            return i;
        }
        return -1;
    }

    public boolean hasValue(float value) {
        if (Float.isNaN(value)) {
            for (int i = 0; i < this.count; ++i) {
                if (!Float.isNaN(this.data[i])) continue;
                return true;
            }
        } else {
            for (int i = 0; i < this.count; ++i) {
                if (this.data[i] != value) continue;
                return true;
            }
        }
        return false;
    }

    public void add(int index, float amount) {
        int n = index;
        this.data[n] = this.data[n] + amount;
    }

    public void sub(int index, float amount) {
        int n = index;
        this.data[n] = this.data[n] - amount;
    }

    public void mult(int index, float amount) {
        int n = index;
        this.data[n] = this.data[n] * amount;
    }

    public void div(int index, float amount) {
        int n = index;
        this.data[n] = this.data[n] / amount;
    }

    private void checkMinMax(String functionName) {
        if (this.count == 0) {
            String msg = String.format("Cannot use %s() on an empty %s.", functionName, this.getClass().getSimpleName());
            throw new RuntimeException(msg);
        }
    }

    public float min() {
        this.checkMinMax("min");
        int index = this.minIndex();
        return index == -1 ? Float.NaN : this.data[index];
    }

    public int minIndex() {
        this.checkMinMax("minIndex");
        float m = Float.NaN;
        int mi = -1;
        for (int i = 0; i < this.count; ++i) {
            if (this.data[i] != this.data[i]) continue;
            m = this.data[i];
            mi = i;
            for (int j = i + 1; j < this.count; ++j) {
                float d = this.data[j];
                if (Float.isNaN(d) || !(d < m)) continue;
                m = this.data[j];
                mi = j;
            }
            break;
        }
        return mi;
    }

    public float max() {
        this.checkMinMax("max");
        int index = this.maxIndex();
        return index == -1 ? Float.NaN : this.data[index];
    }

    public int maxIndex() {
        this.checkMinMax("maxIndex");
        float m = Float.NaN;
        int mi = -1;
        for (int i = 0; i < this.count; ++i) {
            if (this.data[i] != this.data[i]) continue;
            m = this.data[i];
            mi = i;
            for (int j = i + 1; j < this.count; ++j) {
                float d = this.data[j];
                if (Float.isNaN(d) || !(d > m)) continue;
                m = this.data[j];
                mi = j;
            }
            break;
        }
        return mi;
    }

    public void sort() {
        Arrays.sort(this.data, 0, this.count);
    }

    public void sortReverse() {
        new Sort(){

            @Override
            public int size() {
                return FloatList.this.count;
            }

            @Override
            public float compare(int a, int b) {
                return FloatList.this.data[b] - FloatList.this.data[a];
            }

            @Override
            public void swap(int a, int b) {
                float temp = FloatList.this.data[a];
                FloatList.this.data[a] = FloatList.this.data[b];
                FloatList.this.data[b] = temp;
            }
        }.run();
    }

    public void subset(int start) {
        this.subset(start, this.count - start);
    }

    public void subset(int start, int num) {
        for (int i = 0; i < num; ++i) {
            this.data[i] = this.data[i + start];
        }
        this.count = num;
    }

    public void reverse() {
        int ii = this.count - 1;
        for (int i = 0; i < this.count / 2; ++i) {
            float t = this.data[i];
            this.data[i] = this.data[ii];
            this.data[ii] = t;
            --ii;
        }
    }

    public void shuffle() {
        Random r = new Random();
        int num = this.count;
        while (num > 1) {
            int value = r.nextInt(num);
            float temp = this.data[--num];
            this.data[num] = this.data[value];
            this.data[value] = temp;
        }
    }

    public void shuffle(PApplet sketch) {
        int num = this.count;
        while (num > 1) {
            int value = (int)sketch.random(num);
            float temp = this.data[--num];
            this.data[num] = this.data[value];
            this.data[value] = temp;
        }
    }

    public FloatList copy() {
        FloatList outgoing = new FloatList(this.data);
        outgoing.count = this.count;
        return outgoing;
    }

    public float[] values() {
        this.crop();
        return this.data;
    }

    @Override
    public Iterator<Float> iterator() {
        return new Iterator<Float>(){
            int index = -1;

            @Override
            public void remove() {
                FloatList.this.remove(this.index);
            }

            @Override
            public Float next() {
                return Float.valueOf(FloatList.this.data[++this.index]);
            }

            @Override
            public boolean hasNext() {
                return this.index + 1 < FloatList.this.count;
            }
        };
    }

    public float[] array() {
        return this.array(null);
    }

    public float[] array(float[] array) {
        if (array == null || array.length != this.count) {
            array = new float[this.count];
        }
        System.arraycopy(this.data, 0, array, 0, this.count);
        return array;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName() + " size=" + this.size() + " [ ");
        for (int i = 0; i < this.size(); ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(i + ": " + this.data[i]);
        }
        sb.append(" ]");
        return sb.toString();
    }
}

