/*
 * Decompiled with CFR 0.152.
 */
package jpen;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import jpen.PenState;
import jpen.TypedClass;
import jpen.TypedValuedClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PLevel
extends TypedValuedClass<Type, Float>
implements Serializable {
    private static final Logger L = Logger.getLogger(PLevel.class.getName());
    public static final long serialVersionUID = 1L;

    public PLevel(PLevel level) {
        this(level.typeNumber, ((Float)level.value).floatValue());
    }

    public PLevel(Type type, float value) {
        this(type.ordinal(), value);
    }

    public PLevel(int typeNumber, float value) {
        super(typeNumber, Float.valueOf(value));
    }

    @Override
    final List<Type> getAllTypes() {
        return Type.ALL_VALUES;
    }

    public boolean isMovement() {
        return Type.MOVEMENT_TYPES.contains(this.getType());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        X,
        Y,
        PRESSURE,
        TILT_X,
        TILT_Y,
        SIDE_PRESSURE,
        ROTATION,
        CUSTOM;

        public static final List<Type> ALL_VALUES;
        public static final List<Type> VALUES;
        public static final Set<Type> MOVEMENT_TYPES;
        public static final Set<Type> TILT_TYPES;
        private static final double PI_over_2 = 1.5707963267948966;

        public static void evalAzimuthXAndAltitude(double[] azimuthXAndAltitude, PenState pen) {
            Type.evalAzimuthXAndAltitude(azimuthXAndAltitude, pen.getLevelValue(TILT_X), pen.getLevelValue(TILT_Y));
        }

        public static void evalAzimuthXAndAltitude(double[] azimuthXAndAltitude, double tiltX, double tiltY) {
            if (tiltX < 0.0) {
                azimuthXAndAltitude[0] = Math.PI;
            } else {
                if (tiltX == 0.0 && tiltY == 0.0) {
                    azimuthXAndAltitude[0] = 0.0;
                    azimuthXAndAltitude[1] = 1.5707963267948966;
                    return;
                }
                azimuthXAndAltitude[0] = 0.0;
            }
            double tanTiltY = Math.tan(tiltY);
            azimuthXAndAltitude[0] = azimuthXAndAltitude[0] + Math.atan(tanTiltY / Math.tan(tiltX));
            azimuthXAndAltitude[1] = azimuthXAndAltitude[0] == 0.0 ? 1.5707963267948966 - tiltX : Math.abs(Math.atan(Math.sin(azimuthXAndAltitude[0]) / tanTiltY));
        }

        static {
            ALL_VALUES = Collections.unmodifiableList(Arrays.asList(Type.values()));
            VALUES = TypedClass.createStandardTypes(ALL_VALUES);
            MOVEMENT_TYPES = Collections.unmodifiableSet(EnumSet.of(X, Y));
            TILT_TYPES = Collections.unmodifiableSet(EnumSet.of(TILT_X, TILT_Y));
        }
    }
}

