/*
 * Decompiled with CFR 0.152.
 */
package jpen.demo;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jpen.PKind;
import jpen.PenDevice;
import jpen.PenProvider;
import jpen.demo.PKindTypeNumberCombo;
import jpen.event.PenManagerListener;
import jpen.owner.multiAwt.AwtPenToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DevicesTableModel
extends AbstractTableModel
implements PenManagerListener {
    private final List<PenDevice> devices = new ArrayList<PenDevice>();
    final PKindTypeNumberCombo kindTypeNumberCombo = new PKindTypeNumberCombo();
    private boolean supportCustomPKinds;
    private final Column[] columns = new Column[]{new Column<String>("Name (Physical Id)", String.class){

        @Override
        Object getValue(PenDevice device) {
            return device.getName() + " (" + device.getPhysicalId() + ")";
        }
    }, new Column<Integer>("Kind", Integer.class, true){
        private final MyCellRenderer myCellRenderer;
        private final TableCellEditor myCellEditor;
        {
            this.myCellRenderer = new MyCellRenderer();
            this.myCellEditor = new DefaultCellEditor(DevicesTableModel.this.kindTypeNumberCombo.comboBox);
        }

        @Override
        Object getValue(PenDevice device) {
            return device.getKindTypeNumber();
        }

        @Override
        void setValue(Integer val, PenDevice device) {
            try {
                if (device.getKindTypeNumber() == val.intValue()) {
                    return;
                }
                device.setKindTypeNumber(val);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, ex.getMessage());
            }
            DevicesTableModel.this.updateKindTypeNumberCombo();
        }

        @Override
        TableCellRenderer getCellRenderer() {
            return this.myCellRenderer;
        }

        @Override
        TableCellEditor getCellEditor() {
            return this.myCellEditor;
        }

        class MyCellRenderer
        extends DefaultTableCellRenderer {
            MyCellRenderer() {
                this.setHorizontalAlignment(0);
            }

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                this.setText(PKindTypeNumberCombo.getPKindTypeStringValue((Integer)value));
                return this;
            }
        }
    }};

    DevicesTableModel() {
        AwtPenToolkit.getPenManager().addListener(this);
        this.updateDevices();
    }

    void setSupportCustomPKinds(boolean supportCustomPKinds) {
        this.supportCustomPKinds = supportCustomPKinds;
        this.updateKindTypeNumberCombo();
    }

    private void updateDevices() {
        this.devices.clear();
        this.devices.addAll(AwtPenToolkit.getPenManager().getDevices());
        this.updateKindTypeNumberCombo();
        this.fireTableDataChanged();
    }

    private void updateKindTypeNumberCombo() {
        int devicesMax = 0;
        for (PenDevice device : this.devices) {
            if (devicesMax >= device.getKindTypeNumber()) continue;
            devicesMax = device.getKindTypeNumber();
        }
        if (this.supportCustomPKinds && ++devicesMax < PKind.Type.VALUES.size()) {
            devicesMax = PKind.Type.VALUES.size();
        }
        if (devicesMax > this.kindTypeNumberCombo.getMaxPKindTypeNumber()) {
            this.kindTypeNumberCombo.setMaxPKindTypeNumber(devicesMax);
        }
    }

    @Override
    public void penDeviceAdded(PenProvider.Constructor providerConstructor, PenDevice penDevice) {
        this.updateDevices();
    }

    @Override
    public void penDeviceRemoved(PenProvider.Constructor providerConstructor, PenDevice penDevice) {
        this.updateDevices();
    }

    @Override
    public int getRowCount() {
        return this.devices.size();
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.columns[column].getValueAt(row);
    }

    @Override
    public String getColumnName(int col) {
        return this.columns[col].name;
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return this.columns[col].clazz;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return this.columns[col].isCellEditable;
    }

    @Override
    public void setValueAt(Object aValue, int row, int col) {
        this.columns[col].setValueAt(aValue, row);
    }

    public TableCellEditor getCellEditor(int row, int col) {
        return this.columns[col].getCellEditor();
    }

    public TableCellRenderer getCellRenderer(int row, int col) {
        return this.columns[col].getCellRenderer();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class Column<C> {
        final String name;
        final Class<C> clazz;
        final boolean isCellEditable;

        Column(String name, Class<C> clazz) {
            this(name, clazz, false);
        }

        Column(String name, Class<C> clazz, boolean isCellEditable) {
            this.name = name;
            this.clazz = clazz;
            this.isCellEditable = isCellEditable;
        }

        Object getValueAt(int row) {
            return this.getValue((PenDevice)DevicesTableModel.this.devices.get(row));
        }

        abstract Object getValue(PenDevice var1);

        void setValueAt(Object val, int row) {
            this.setValue(this.clazz.cast(val), (PenDevice)DevicesTableModel.this.devices.get(row));
        }

        void setValue(C val, PenDevice device) {
        }

        TableCellEditor getCellEditor() {
            return null;
        }

        TableCellRenderer getCellRenderer() {
            return null;
        }
    }
}

