/*
 * Decompiled with CFR 0.152.
 */
package jpen.demo;

import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JTextField;
import jpen.PLevelEvent;
import jpen.Pen;
import jpen.event.PenAdapter;

class SampleRatePanel {
    public static final int SAMPLE_COUNT = 10;
    private final LinkedList<Integer> periods = new LinkedList();
    private int average;
    private final JTextField textField = new JTextField(7);
    final JTextField panel;

    SampleRatePanel(Pen pen) {
        this.textField.setEditable(false);
        this.textField.setHorizontalAlignment(4);
        this.panel = this.textField;
        pen.addListener(new PenAdapter(){
            private long lastDeviceTime = -1L;

            public void penLevelEvent(PLevelEvent ev) {
                long evDeviceTime = ev.getDeviceTime();
                if (this.lastDeviceTime == -1L) {
                    this.lastDeviceTime = evDeviceTime;
                    return;
                }
                long period = evDeviceTime - this.lastDeviceTime;
                SampleRatePanel.this.addPeriod((int)period);
                this.lastDeviceTime = evDeviceTime;
            }

            public void penTock(long availableMillis) {
                SampleRatePanel.this.updateTextField();
            }
        });
    }

    void addPeriod(int period) {
        if (this.periods.size() == 10) {
            this.periods.removeFirst();
        }
        this.periods.add(period);
    }

    void updateAverage() {
        this.average = 0;
        Iterator i$ = this.periods.iterator();
        while (i$.hasNext()) {
            int period = (Integer)i$.next();
            this.average += period;
        }
        if (this.periods.size() > 0) {
            this.average /= this.periods.size();
        }
    }

    void updateTextField() {
        this.updateAverage();
        this.textField.setText(this.average + " ms");
    }
}

