/*
 * Decompiled with CFR 0.152.
 */
package jpen.internal.filter;

import java.awt.MouseInfo;
import java.awt.PointerInfo;
import java.awt.geom.Point2D;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.logging.Logger;
import jpen.PLevel;
import jpen.PenDevice;
import jpen.PenState;
import jpen.internal.filter.AbsoluteLocationRule;
import jpen.internal.filter.AbsoluteOnARowRule;
import jpen.internal.filter.RelativeOnSlopesRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RelativeLocationFilter {
    private static final Logger L = Logger.getLogger(RelativeLocationFilter.class.getName());
    private PenDevice penDevice;
    private State state = State.UNDEFINED;
    final Point2D.Float reference = new Point2D.Float();
    final SamplePoint samplePoint = new SamplePoint();
    final Point2D.Float deviation = new Point2D.Float();
    final Point2D.Float absDeviation = new Point2D.Float();
    private final Rule[] rules = new Rule[]{new AbsoluteLocationRule(), new AbsoluteOnARowRule(), new RelativeOnSlopesRule()};
    private final PrivilegedAction<PointerInfo> getPointerInfoAction = new PrivilegedAction<PointerInfo>(){

        @Override
        public PointerInfo run() {
            return MouseInfo.getPointerInfo();
        }
    };

    public void reset() {
        this.penDevice = null;
        this.resetRules();
    }

    private void resetRules() {
        for (Rule rule : this.rules) {
            rule.reset();
        }
    }

    public boolean filter(PenState penState, PenDevice penDevice, Collection<PLevel> sample, boolean levelsOnScreen) {
        if (!levelsOnScreen) {
            return false;
        }
        if (this.state.equals((Object)State.OFF)) {
            return false;
        }
        if (this.penDevice != penDevice) {
            this.penDevice = penDevice;
            this.state = State.UNDEFINED;
            this.resetRules();
        }
        if (this.state.equals((Object)State.ABSOLUTE)) {
            return false;
        }
        if (RelativeLocationFilter.evalIsSystemMouseDevice(penDevice)) {
            return false;
        }
        if (!this.samplePoint.reset(sample)) {
            return false;
        }
        if (!this.setupReference()) {
            return true;
        }
        boolean stateChanged = false;
        if (this.state.equals((Object)State.UNDEFINED)) {
            this.setupDeviation();
            stateChanged = this.evalStateFromRules();
        }
        switch (this.state) {
            case ABSOLUTE: {
                break;
            }
            case RELATIVE: {
                this.samplePoint.set(this.reference.x, this.reference.y, sample);
                break;
            }
            case UNDEFINED: {
                this.samplePoint.set(penState.getLevelValue(PLevel.Type.X), penState.getLevelValue(PLevel.Type.Y));
                break;
            }
        }
        return stateChanged;
    }

    private static boolean evalIsSystemMouseDevice(PenDevice device) {
        return device.getProvider().getConstructor().getPenManager().isSystemMouseDevice(device);
    }

    private boolean setupReference() {
        PointerInfo pointerInfo = AccessController.doPrivileged(this.getPointerInfoAction);
        if (pointerInfo == null) {
            L.warning("No mouse found. Can not correct devices on relative (mouse) mode.");
            this.state = State.OFF;
            return false;
        }
        this.reference.setLocation(pointerInfo.getLocation());
        return true;
    }

    private void setupDeviation() {
        if (this.samplePoint.levelX != null) {
            this.deviation.x = ((Float)this.samplePoint.levelX.value).floatValue() - this.reference.x;
            this.absDeviation.x = Math.abs(this.deviation.x);
        }
        if (this.samplePoint.levelY != null) {
            this.deviation.y = ((Float)this.samplePoint.levelY.value).floatValue() - this.reference.y;
            this.absDeviation.y = Math.abs(this.deviation.y);
        }
    }

    private boolean evalStateFromRules() {
        for (Rule rule : this.rules) {
            State nextState = rule.evalFilterNextState(this);
            if (nextState == null) continue;
            this.state = nextState;
            return true;
        }
        return false;
    }

    public State getState() {
        return this.state;
    }

    static interface Rule {
        public void reset();

        public State evalFilterNextState(RelativeLocationFilter var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SamplePoint
    implements Cloneable {
        PLevel levelX;
        PLevel levelY;
        boolean isComplete;

        SamplePoint() {
        }

        /*
         * Enabled aggressive block sorting
         */
        boolean reset(Collection<PLevel> sample) {
            this.levelY = null;
            this.levelX = null;
            int valuesCount = 0;
            block4: for (PLevel level : sample) {
                switch ((PLevel.Type)((Object)level.getType())) {
                    case X: {
                        ++valuesCount;
                        this.levelX = level;
                        if (this.levelY == null) break;
                        break block4;
                    }
                    case Y: {
                        ++valuesCount;
                        this.levelY = level;
                        if (this.levelX != null) break block4;
                    }
                }
            }
            this.isComplete = valuesCount == 2;
            if (valuesCount <= 0) return false;
            return true;
        }

        private void set(float x, float y) {
            this.set(x, y, null);
        }

        private void set(float x, float y, Collection<PLevel> sample) {
            if (this.levelX != null) {
                this.levelX.value = Float.valueOf(x);
            } else if (sample != null) {
                sample.add(new PLevel(PLevel.Type.X, x));
            }
            if (this.levelY != null) {
                this.levelY.value = Float.valueOf(y);
            } else if (sample != null) {
                sample.add(new PLevel(PLevel.Type.Y, y));
            }
        }

        public SamplePoint clone() {
            try {
                SamplePoint clone = (SamplePoint)super.clone();
                clone.levelX = new PLevel(this.levelX);
                clone.levelY = new PLevel(this.levelY);
                return clone;
            }
            catch (CloneNotSupportedException ex) {
                throw new AssertionError((Object)ex);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        UNDEFINED,
        ABSOLUTE,
        RELATIVE,
        OFF;

    }
}

