/*
 * Decompiled with CFR 0.152.
 */
package jpen.owner.awt;

import java.awt.Component;
import java.awt.Point;
import java.awt.geom.Point2D;
import javax.swing.SwingUtilities;
import jpen.owner.PenClip;
import jpen.owner.awt.ComponentPenOwner;

final class ComponentPenClip
implements PenClip {
    final ComponentPenOwner componentPenOwner;

    public ComponentPenClip(ComponentPenOwner componentPenOwner) {
        this.componentPenOwner = componentPenOwner;
    }

    public void evalLocationOnScreen(Point pointOnScreen) {
        Component activeComponent = this.componentPenOwner.getActiveComponent();
        if (activeComponent == null) {
            return;
        }
        pointOnScreen.y = 0;
        pointOnScreen.x = 0;
        SwingUtilities.convertPointToScreen(pointOnScreen, activeComponent);
    }

    public boolean contains(Point2D.Float point) {
        Component activeComponent = this.componentPenOwner.getActiveComponent();
        if (activeComponent == null) {
            return false;
        }
        return !(point.x < 0.0f || point.y < 0.0f || point.x > (float)activeComponent.getWidth()) && !(point.y > (float)activeComponent.getHeight());
    }
}

