/*
 * Decompiled with CFR 0.152.
 */
package jpen.owner.awt;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.SwingUtilities;
import jpen.PenProvider;
import jpen.internal.ActiveWindowProperty;
import jpen.owner.AbstractPenOwner;
import jpen.owner.PenClip;
import jpen.owner.awt.ComponentPenClip;
import jpen.provider.osx.CocoaProvider;
import jpen.provider.system.SystemProvider;
import jpen.provider.wintab.WintabProvider;
import jpen.provider.xinput.XinputProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ComponentPenOwner
extends AbstractPenOwner {
    private final ComponentPenClip componentPenClip = new ComponentPenClip(this);
    protected final Unpauser unpauser = new Unpauser();
    private final ActiveWindowPL activeWindowPL = new ActiveWindowPL();

    public abstract Component getActiveComponent();

    @Override
    public final Collection<PenProvider.Constructor> getPenProviderConstructors() {
        return Arrays.asList(new SystemProvider.Constructor(), new XinputProvider.Constructor(), new WintabProvider.Constructor(), new CocoaProvider.Constructor());
    }

    @Override
    public final PenClip getPenClip() {
        return this.componentPenClip;
    }

    protected final void pause() {
        this.unpauser.disable();
        this.activeWindowPL.setEnabled(false);
        this.penManagerHandle.setPenManagerPaused(true);
    }

    @Override
    protected void draggingOutDisengaged() {
        this.pause();
    }

    protected Object getPenSchedulerLock(Component component) {
        if (component != null) {
            Thread.currentThread();
            if (Thread.holdsLock(component.getTreeLock())) {
                throw new AssertionError((Object)"tryed to hold penSchedulerLock while holding Component's treeLock");
            }
        }
        return this.penManagerHandle.getPenSchedulerLock();
    }

    private class ActiveWindowPL
    implements ActiveWindowProperty.Listener {
        private boolean enabled;
        private ActiveWindowProperty activeWindowP;

        private ActiveWindowPL() {
        }

        void setEnabled(boolean enabled) {
            if (this.activeWindowP == null) {
                this.activeWindowP = new ActiveWindowProperty(this);
            }
            this.enabled = enabled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void activeWindowChanged(Window activeWindow) {
            if (!this.enabled) {
                return;
            }
            Object object = ComponentPenOwner.this.getPenSchedulerLock(activeWindow);
            synchronized (object) {
                Dialog activeDialog;
                if (activeWindow == null) {
                    this.pauseAMoment();
                    return;
                }
                Window componentWindow = SwingUtilities.getWindowAncestor(ComponentPenOwner.this.getActiveComponent());
                if (componentWindow == null) {
                    return;
                }
                if (activeWindow != componentWindow && activeWindow instanceof Dialog && (activeDialog = (Dialog)activeWindow).isModal()) {
                    this.pauseAMoment();
                }
            }
        }

        private void pauseAMoment() {
            ComponentPenOwner.this.pause();
            ComponentPenOwner.this.unpauser.enable();
        }
    }

    protected final class Unpauser
    implements MouseMotionListener {
        private volatile boolean enabled;
        private WeakReference<Component> myActiveComponentRef;

        protected Unpauser() {
        }

        public synchronized void enable() {
            if (this.enabled) {
                return;
            }
            Component myActiveComponent = ComponentPenOwner.this.getActiveComponent();
            this.myActiveComponentRef = new WeakReference<Component>(myActiveComponent);
            myActiveComponent.addMouseMotionListener(ComponentPenOwner.this.unpauser);
            this.enabled = true;
        }

        synchronized void disable() {
            if (!this.enabled) {
                return;
            }
            Component myActiveComponent = (Component)this.myActiveComponentRef.get();
            if (myActiveComponent != null) {
                myActiveComponent.removeMouseMotionListener(ComponentPenOwner.this.unpauser);
                myActiveComponent = null;
            }
            this.enabled = false;
        }

        public void mouseMoved(MouseEvent ev) {
            this.unpause();
        }

        public void mouseDragged(MouseEvent ev) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void unpause() {
            Object object = ComponentPenOwner.this.penManagerHandle.getPenSchedulerLock();
            synchronized (object) {
                if (this.enabled) {
                    ComponentPenOwner.this.activeWindowPL.setEnabled(true);
                    ComponentPenOwner.this.penManagerHandle.setPenManagerPaused(false);
                    this.disable();
                }
            }
        }
    }
}

