/*
 * Decompiled with CFR 0.152.
 */
package jpen.owner.multiAwt;

import java.awt.Component;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import jpen.PButtonEvent;
import jpen.PKindEvent;
import jpen.PLevelEvent;
import jpen.PScrollEvent;
import jpen.PenEvent;
import jpen.event.PenListener;
import jpen.internal.WeakChain;
import jpen.owner.PenOwner;
import jpen.owner.awt.ComponentPenOwner;
import jpen.owner.multiAwt.ComponentPool;

final class MultiAwtPenOwner
extends ComponentPenOwner
implements ComponentPool.Listener {
    private static final Logger L = Logger.getLogger(MultiAwtPenOwner.class.getName());
    final ComponentPool componentPool = new ComponentPool(this);
    private ActiveComponentInfo activeComponentInfo = ActiveComponentInfo.emptyInstance;
    private final PenListener penMulticaster = new PenListener(){
        private final Listeners listeners = new Listeners();
        private static final long NANOS_TO_MILLIS_DIV = 1000000L;

        public void penKindEvent(PKindEvent ev) {
            this.updateListeners(ev);
            for (PenListener listener : this.listeners) {
                listener.penKindEvent(ev);
            }
        }

        private void updateListeners(PenEvent ev) {
            this.listeners.setActiveComponentInfo((ActiveComponentInfo)MultiAwtPenOwner.this.penManagerHandle.retrievePenEventTag(ev));
        }

        public void penLevelEvent(PLevelEvent ev) {
            this.updateListeners(ev);
            for (PenListener listener : this.listeners) {
                listener.penLevelEvent(ev);
            }
        }

        public void penButtonEvent(PButtonEvent ev) {
            this.updateListeners(ev);
            for (PenListener listener : this.listeners) {
                listener.penButtonEvent(ev);
            }
        }

        public void penScrollEvent(PScrollEvent ev) {
            this.updateListeners(ev);
            for (PenListener listener : this.listeners) {
                listener.penScrollEvent(ev);
            }
        }

        public void penTock(long availableMillis) {
            long spentTimeMillis = 0L;
            for (PenListener listener : this.listeners) {
                long startTimeNanos = System.nanoTime();
                listener.penTock(availableMillis -= spentTimeMillis);
                spentTimeMillis = (System.nanoTime() - startTimeNanos) / 1000000L;
            }
            this.listeners.setActiveComponentInfo(null);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Listeners
        extends ArrayList<PenListener> {
            private ActiveComponentInfo activeComponentInfo;

            Listeners() {
            }

            void setActiveComponentInfo(ActiveComponentInfo activeComponentInfo) {
                if (this.activeComponentInfo == activeComponentInfo) {
                    return;
                }
                this.activeComponentInfo = activeComponentInfo;
                this.clear();
                if (activeComponentInfo != null) {
                    activeComponentInfo.getPenListeners(listeners);
                }
            }
        }
    };

    MultiAwtPenOwner() {
    }

    PenOwner.PenManagerHandle getPenManagerHandle() {
        return this.penManagerHandle;
    }

    public boolean enforceSinglePenManager() {
        return true;
    }

    protected void init() {
        this.componentPool.setListener(this);
        this.penManagerHandle.getPenManager().pen.addListener(this.penMulticaster);
    }

    public Component getActiveComponent() {
        return this.activeComponentInfo == null ? null : this.activeComponentInfo.getComponent();
    }

    public void pointerComponentChanged(Component component) {
        this.setActiveComponent(component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setActiveComponent(Component component) {
        Object object = this.getPenSchedulerLock(component);
        synchronized (object) {
            if (component == null) {
                if (!this.startDraggingOut()) {
                    this.pause();
                    this.activeComponentInfo = ActiveComponentInfo.emptyInstance;
                }
            } else if (this.isDraggingOut()) {
                if (component == this.getActiveComponent() && !this.stopDraggingOut()) {
                    throw new AssertionError();
                }
            } else {
                this.activeComponentInfo = new ActiveComponentInfo(component, this.componentPool.getPenListeners(component));
                this.unpauser.enable();
            }
        }
    }

    public void componentRemoved(Component component) {
        Thread.currentThread();
        System.out.println(Thread.holdsLock(component.getTreeLock()));
        this.stopDraggingOutAndPause(component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopDraggingOutAndPause(Component component) {
        Object object = this.getPenSchedulerLock(component);
        synchronized (object) {
            if (this.getActiveComponent() == component && this.stopDraggingOut()) {
                this.pause();
            }
        }
    }

    public void componentUndisplayable(final Component component) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MultiAwtPenOwner.this.stopDraggingOutAndPause(component);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pointerComponentPenListenersChanged(Component pointerComponent) {
        Object object = this.getPenSchedulerLock();
        synchronized (object) {
            if (pointerComponent == this.getActiveComponent()) {
                this.activeComponentInfo = new ActiveComponentInfo(pointerComponent, this.componentPool.getPenListeners(pointerComponent));
            }
        }
    }

    protected void draggingOutDisengaged() {
        super.draggingOutDisengaged();
        Component pointerComponent = this.componentPool.getPointerComponent();
        if (pointerComponent != null && pointerComponent != this.getActiveComponent()) {
            this.setActiveComponent(pointerComponent);
        }
    }

    public ActiveComponentInfo evalPenEventTag(PenEvent ev) {
        return this.activeComponentInfo;
    }

    public Object getPenSchedulerLock() {
        return this.getPenSchedulerLock(null);
    }

    public Object getPenSchedulerLock(Component component) {
        return super.getPenSchedulerLock(component);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ActiveComponentInfo {
        private final WeakReference<Component> componentRef;
        private final WeakChain<PenListener> penListenersChain = new WeakChain();
        static final ActiveComponentInfo emptyInstance = new ActiveComponentInfo(null, null);

        ActiveComponentInfo(Component component, PenListener[] penListeners) {
            this.componentRef = new WeakReference<Component>(component);
            if (penListeners != null) {
                for (PenListener penListener : penListeners) {
                    this.penListenersChain.add(penListener);
                }
            }
        }

        Component getComponent() {
            return (Component)this.componentRef.get();
        }

        void getPenListeners(Collection<PenListener> penListeners) {
            this.penListenersChain.snapshot(penListeners);
        }
    }
}

