/*
 * Decompiled with CFR 0.152.
 */
package jpen.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jpen.PenDevice;
import jpen.PenManager;
import jpen.PenProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPenProvider
implements PenProvider {
    private final PenProvider.Constructor constructor;
    protected final List<PenDevice> devices = new ArrayList<PenDevice>();
    private final List<PenDevice> devicesA = Collections.unmodifiableList(this.devices);

    protected AbstractPenProvider(PenProvider.Constructor constructor) {
        this.constructor = constructor;
    }

    @Override
    public Collection<PenDevice> getDevices() {
        return this.devicesA;
    }

    public final PenManager getPenManager() {
        return this.getConstructor().getPenManager();
    }

    @Override
    public final PenProvider.Constructor getConstructor() {
        return this.constructor;
    }

    @Override
    public boolean getUseRelativeLocationFilter() {
        return false;
    }

    public String toString() {
        return "[PenProvider: constructor.name=" + this.getConstructor().getName() + "]";
    }

    public static abstract class AbstractConstructor
    implements PenProvider.Constructor {
        private PenManager penManager;
        private PenProvider constructed;
        private PenProvider.ConstructionException constructionException;

        public PenManager getPenManager() {
            return this.penManager;
        }

        public PenProvider.ConstructionException getConstructionException() {
            return this.constructionException;
        }

        public PenProvider getConstructed() {
            return this.constructed;
        }

        public final boolean construct(PenManager penManager) {
            if (this.penManager != null) {
                throw new IllegalStateException("constructor already used by PenManager");
            }
            this.penManager = penManager;
            try {
                this.checkExpectedNativeBuild();
                this.constructed = this.constructProvider();
            }
            catch (Throwable t) {
                this.constructionException = new PenProvider.ConstructionException(t);
                return false;
            }
            return true;
        }

        protected abstract PenProvider constructProvider() throws Throwable;

        private void checkExpectedNativeBuild() throws IllegalStateException {
            if (this.getExpectedNativeBuild() > this.getNativeBuild()) {
                throw new IllegalStateException("expectedNativeBuild number (" + this.getExpectedNativeBuild() + ") is greater than library's nativeBuild number (" + this.getNativeBuild() + ")");
            }
        }

        public int getNativeVersion() {
            return -1;
        }

        public int getNativeBuild() {
            return -1;
        }

        public int getExpectedNativeBuild() {
            return -1;
        }
    }
}

