/*
 * Decompiled with CFR 0.152.
 */
package jpen.provider;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.geom.Rectangle2D;
import java.util.logging.Logger;
import jpen.PLevel;

public final class VirtualScreenBounds {
    static final Logger L = Logger.getLogger(VirtualScreenBounds.class.getName());
    private static VirtualScreenBounds INSTANCE;
    private final Rectangle2D.Float r = new Rectangle2D.Float();

    private VirtualScreenBounds() {
        new Thread(){
            {
                this.setName("jpen-VirtualScreenBounds");
                this.setDaemon(true);
            }

            public void run() {
                VirtualScreenBounds.this.reset();
                L.fine("first calculation done.");
            }
        }.start();
    }

    public static VirtualScreenBounds getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new VirtualScreenBounds();
        }
        return INSTANCE;
    }

    public synchronized void reset() {
        this.r.height = 0.0f;
        this.r.width = 0.0f;
        this.r.y = 0.0f;
        this.r.x = 0.0f;
        VirtualScreenBounds.calc(this.r);
    }

    static void calc(Rectangle2D r) {
        for (GraphicsDevice gd : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
            GraphicsConfiguration graphicsConfiguration = gd.getDefaultConfiguration();
            r.add(graphicsConfiguration.getBounds());
        }
    }

    public float getLevelRangeMult(PLevel.Type type) {
        switch (type) {
            case X: {
                return this.r.width;
            }
            case Y: {
                return this.r.height;
            }
        }
        return 1.0f;
    }

    public float getLevelRangeOffset(PLevel.Type type) {
        switch (type) {
            case X: {
                return this.r.x;
            }
            case Y: {
                return this.r.y;
            }
        }
        return 0.0f;
    }
}

