import generativedesign.*;
import processing.pdf.*;

PImage sea;
color[] colors;
String sortMode = null;

void setup() {
  size(500, 500);
  colorMode(HSB, 360, 100, 100, 100);
  sea = loadImage("sea.png");
}


void draw() {

  // sort colors
  if (sortMode != null) colors = GenerativeDesign.sortColors(this, colors, sortMode);

  int i = 0;
  colors = new color[width*height];


  for (int y = 0; y < width; y++) {
    for (int x = 0; x < height; x++) {
      int px = x;
      int py = y;
      colors[i] = sea.get(px, py);
      i++;
    }
  }


  i = 0;
  for (int y = 0; i < height; y++) {
    for (int x = 0; x < width; x++) {
      fill(colors[i]);
      rect(x, y, 1, 1);
      i++;
    }
  }
}

void keyReleased() {

  if (key == '4') sortMode = null;
  if (key == '5') sortMode = GenerativeDesign.HUE;
  if (key == '6') sortMode = GenerativeDesign.SATURATION;
  if (key == '7') sortMode = GenerativeDesign.BRIGHTNESS;
  if (key == '8') sortMode = GenerativeDesign.GRAYSCALE;
}

